/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.resourcemanager.appservice.models.Correlation;
import com.azure.resourcemanager.appservice.models.ResourceReference;
import com.azure.resourcemanager.appservice.models.WorkflowOutputParameter;
import com.azure.resourcemanager.appservice.models.WorkflowRunTrigger;
import com.azure.resourcemanager.appservice.models.WorkflowStatus;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.Map;

public final class WorkflowRunProperties {
    @JsonProperty(value="waitEndTime", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime waitEndTime;
    @JsonProperty(value="startTime", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime startTime;
    @JsonProperty(value="endTime", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime endTime;
    @JsonProperty(value="status", access=JsonProperty.Access.WRITE_ONLY)
    private WorkflowStatus status;
    @JsonProperty(value="code", access=JsonProperty.Access.WRITE_ONLY)
    private String code;
    @JsonProperty(value="error", access=JsonProperty.Access.WRITE_ONLY)
    private Object error;
    @JsonProperty(value="correlationId", access=JsonProperty.Access.WRITE_ONLY)
    private String correlationId;
    @JsonProperty(value="correlation")
    private Correlation correlation;
    @JsonProperty(value="workflow", access=JsonProperty.Access.WRITE_ONLY)
    private ResourceReference workflow;
    @JsonProperty(value="trigger", access=JsonProperty.Access.WRITE_ONLY)
    private WorkflowRunTrigger trigger;
    @JsonProperty(value="outputs", access=JsonProperty.Access.WRITE_ONLY)
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, WorkflowOutputParameter> outputs;
    @JsonProperty(value="response", access=JsonProperty.Access.WRITE_ONLY)
    private WorkflowRunTrigger response;

    public OffsetDateTime waitEndTime() {
        return this.waitEndTime;
    }

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public OffsetDateTime endTime() {
        return this.endTime;
    }

    public WorkflowStatus status() {
        return this.status;
    }

    public String code() {
        return this.code;
    }

    public Object error() {
        return this.error;
    }

    public String correlationId() {
        return this.correlationId;
    }

    public Correlation correlation() {
        return this.correlation;
    }

    public WorkflowRunProperties withCorrelation(Correlation correlation) {
        this.correlation = correlation;
        return this;
    }

    public ResourceReference workflow() {
        return this.workflow;
    }

    public WorkflowRunTrigger trigger() {
        return this.trigger;
    }

    public Map<String, WorkflowOutputParameter> outputs() {
        return this.outputs;
    }

    public WorkflowRunTrigger response() {
        return this.response;
    }

    public void validate() {
        if (this.correlation() != null) {
            this.correlation().validate();
        }
        if (this.workflow() != null) {
            this.workflow().validate();
        }
        if (this.trigger() != null) {
            this.trigger().validate();
        }
        if (this.outputs() != null) {
            this.outputs().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
        if (this.response() != null) {
            this.response().validate();
        }
    }
}

