// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for DeploymentResourceStatus. */
public final class DeploymentResourceStatus extends ExpandableStringEnum<DeploymentResourceStatus> {
    /** Static value Stopped for DeploymentResourceStatus. */
    public static final DeploymentResourceStatus STOPPED = fromString("Stopped");

    /** Static value Running for DeploymentResourceStatus. */
    public static final DeploymentResourceStatus RUNNING = fromString("Running");

    /**
     * Creates or finds a DeploymentResourceStatus from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding DeploymentResourceStatus.
     */
    @JsonCreator
    public static DeploymentResourceStatus fromString(String name) {
        return fromString(name, DeploymentResourceStatus.class);
    }

    /**
     * Gets known DeploymentResourceStatus values.
     *
     * @return known DeploymentResourceStatus values.
     */
    public static Collection<DeploymentResourceStatus> values() {
        return values(DeploymentResourceStatus.class);
    }
}
