/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.queue.models;

import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class QueueItem
implements XmlSerializable<QueueItem> {
    private String name;
    private Map<String, String> metadata;

    public String getName() {
        return this.name;
    }

    public QueueItem setName(String name) {
        this.name = name;
        return this;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public QueueItem setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = rootElementName == null || rootElementName.isEmpty() ? "Queue" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeStringElement("Name", this.name);
        if (this.metadata != null) {
            xmlWriter.writeStartElement("Metadata");
            for (Map.Entry<String, String> entry : this.metadata.entrySet()) {
                xmlWriter.writeStringElement(entry.getKey(), entry.getValue());
            }
            xmlWriter.writeEndElement();
        }
        return xmlWriter.writeEndElement();
    }

    public static QueueItem fromXml(XmlReader xmlReader) throws XMLStreamException {
        return QueueItem.fromXml(xmlReader, null);
    }

    public static QueueItem fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = rootElementName == null || rootElementName.isEmpty() ? "Queue" : rootElementName;
        return (QueueItem)xmlReader.readObject(finalRootElementName, reader -> {
            QueueItem deserializedQueueItem = new QueueItem();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("Name".equals(elementName.getLocalPart())) {
                    deserializedQueueItem.name = reader.getStringElement();
                    continue;
                }
                if ("Metadata".equals(elementName.getLocalPart())) {
                    while (reader.nextElement() != XmlToken.END_ELEMENT) {
                        if (deserializedQueueItem.metadata == null) {
                            deserializedQueueItem.metadata = new LinkedHashMap<String, String>();
                        }
                        deserializedQueueItem.metadata.put(reader.getElementName().getLocalPart(), reader.getStringElement());
                    }
                    continue;
                }
                reader.skipElement();
            }
            return deserializedQueueItem;
        });
    }
}

