/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.queue.implementation;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.CookiePolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.storage.queue.implementation.MessageIdsImpl;
import com.azure.storage.queue.implementation.MessagesImpl;
import com.azure.storage.queue.implementation.QueuesImpl;
import com.azure.storage.queue.implementation.ServicesImpl;

public final class AzureQueueStorageImpl {
    private final String url;
    private final String version;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final ServicesImpl services;
    private final QueuesImpl queues;
    private final MessagesImpl messages;
    private final MessageIdsImpl messageIds;

    public String getUrl() {
        return this.url;
    }

    public String getVersion() {
        return this.version;
    }

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    public ServicesImpl getServices() {
        return this.services;
    }

    public QueuesImpl getQueues() {
        return this.queues;
    }

    public MessagesImpl getMessages() {
        return this.messages;
    }

    public MessageIdsImpl getMessageIds() {
        return this.messageIds;
    }

    AzureQueueStorageImpl(String url, String version) {
        this(new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy(), new CookiePolicy()}).build(), JacksonAdapter.createDefaultSerializerAdapter(), url, version);
    }

    AzureQueueStorageImpl(HttpPipeline httpPipeline, String url, String version) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), url, version);
    }

    AzureQueueStorageImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String url, String version) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.url = url;
        this.version = version;
        this.services = new ServicesImpl(this);
        this.queues = new QueuesImpl(this);
        this.messages = new MessagesImpl(this);
        this.messageIds = new MessageIdsImpl(this);
    }
}

