/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.models;

import com.azure.core.util.CoreUtils;
import com.azure.storage.file.share.models.ShareCorsRule;
import com.azure.storage.file.share.models.ShareMetrics;
import com.azure.storage.file.share.models.ShareProtocolSettings;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class ShareServiceProperties
implements XmlSerializable<ShareServiceProperties> {
    private ShareMetrics hourMetrics;
    private ShareMetrics minuteMetrics;
    private List<ShareCorsRule> cors;
    private ShareProtocolSettings protocol;

    public ShareMetrics getHourMetrics() {
        return this.hourMetrics;
    }

    public ShareServiceProperties setHourMetrics(ShareMetrics hourMetrics) {
        this.hourMetrics = hourMetrics;
        return this;
    }

    public ShareMetrics getMinuteMetrics() {
        return this.minuteMetrics;
    }

    public ShareServiceProperties setMinuteMetrics(ShareMetrics minuteMetrics) {
        this.minuteMetrics = minuteMetrics;
        return this;
    }

    public List<ShareCorsRule> getCors() {
        if (this.cors == null) {
            this.cors = new ArrayList<ShareCorsRule>();
        }
        return this.cors;
    }

    public ShareServiceProperties setCors(List<ShareCorsRule> cors) {
        this.cors = cors;
        return this;
    }

    public ShareProtocolSettings getProtocol() {
        return this.protocol;
    }

    public ShareServiceProperties setProtocol(ShareProtocolSettings protocol) {
        this.protocol = protocol;
        return this;
    }

    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "StorageServiceProperties" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeXml((XmlSerializable)this.hourMetrics, "HourMetrics");
        xmlWriter.writeXml((XmlSerializable)this.minuteMetrics, "MinuteMetrics");
        if (this.cors != null) {
            xmlWriter.writeStartElement("Cors");
            for (ShareCorsRule element : this.cors) {
                xmlWriter.writeXml((XmlSerializable)element, "CorsRule");
            }
            xmlWriter.writeEndElement();
        }
        xmlWriter.writeXml((XmlSerializable)this.protocol, "ProtocolSettings");
        return xmlWriter.writeEndElement();
    }

    public static ShareServiceProperties fromXml(XmlReader xmlReader) throws XMLStreamException {
        return ShareServiceProperties.fromXml(xmlReader, null);
    }

    public static ShareServiceProperties fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "StorageServiceProperties" : rootElementName;
        return (ShareServiceProperties)xmlReader.readObject(finalRootElementName, reader -> {
            ShareServiceProperties deserializedShareServiceProperties = new ShareServiceProperties();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("HourMetrics".equals(elementName.getLocalPart())) {
                    deserializedShareServiceProperties.hourMetrics = ShareMetrics.fromXml(reader, "HourMetrics");
                    continue;
                }
                if ("MinuteMetrics".equals(elementName.getLocalPart())) {
                    deserializedShareServiceProperties.minuteMetrics = ShareMetrics.fromXml(reader, "MinuteMetrics");
                    continue;
                }
                if ("Cors".equals(elementName.getLocalPart())) {
                    while (reader.nextElement() != XmlToken.END_ELEMENT) {
                        elementName = reader.getElementName();
                        if ("CorsRule".equals(elementName.getLocalPart())) {
                            if (deserializedShareServiceProperties.cors == null) {
                                deserializedShareServiceProperties.cors = new ArrayList<ShareCorsRule>();
                            }
                            deserializedShareServiceProperties.cors.add(ShareCorsRule.fromXml(reader, "CorsRule"));
                            continue;
                        }
                        reader.skipElement();
                    }
                    continue;
                }
                if ("ProtocolSettings".equals(elementName.getLocalPart())) {
                    deserializedShareServiceProperties.protocol = ShareProtocolSettings.fromXml(reader, "ProtocolSettings");
                    continue;
                }
                reader.skipElement();
            }
            return deserializedShareServiceProperties;
        });
    }
}

