/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.implementation.models;

import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.storage.file.share.models.CopyStatusType;
import com.azure.storage.file.share.models.LeaseDurationType;
import com.azure.storage.file.share.models.LeaseStateType;
import com.azure.storage.file.share.models.LeaseStatusType;
import java.time.OffsetDateTime;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.Map;

public final class FilesDownloadHeaders {
    private String xMsFileId;
    private LeaseStatusType xMsLeaseStatus;
    private OffsetDateTime xMsFileCreationTime;
    private String contentRange;
    private LeaseStateType xMsLeaseState;
    private byte[] xMsContentMd5;
    private DateTimeRfc1123 lastModified;
    private String xMsStructuredBody;
    private String xMsMode;
    private String xMsFileAttributes;
    private Long xMsStructuredContentLength;
    private String contentEncoding;
    private String xMsCopyStatusDescription;
    private LeaseDurationType xMsLeaseDuration;
    private Long contentLength;
    private String xMsRequestId;
    private String xMsOwner;
    private String contentType;
    private String xMsGroup;
    private String xMsVersion;
    private String xMsFilePermissionKey;
    private String xMsCopyId;
    private String xMsCopySource;
    private String xMsCopyProgress;
    private Map<String, String> xMsMeta;
    private DateTimeRfc1123 date;
    private byte[] contentMD5;
    private String acceptRanges;
    private DateTimeRfc1123 xMsCopyCompletionTime;
    private Boolean xMsServerEncrypted;
    private String cacheControl;
    private String eTag;
    private Long xMsLinkCount;
    private String contentDisposition;
    private OffsetDateTime xMsFileChangeTime;
    private String xMsFileParentId;
    private CopyStatusType xMsCopyStatus;
    private String contentLanguage;
    private OffsetDateTime xMsFileLastWriteTime;
    private static final HttpHeaderName X_MS_FILE_ID = HttpHeaderName.fromString((String)"x-ms-file-id");
    private static final HttpHeaderName X_MS_LEASE_STATUS = HttpHeaderName.fromString((String)"x-ms-lease-status");
    private static final HttpHeaderName X_MS_FILE_CREATION_TIME = HttpHeaderName.fromString((String)"x-ms-file-creation-time");
    private static final HttpHeaderName X_MS_LEASE_STATE = HttpHeaderName.fromString((String)"x-ms-lease-state");
    private static final HttpHeaderName X_MS_CONTENT_MD5 = HttpHeaderName.fromString((String)"x-ms-content-md5");
    private static final HttpHeaderName X_MS_STRUCTURED_BODY = HttpHeaderName.fromString((String)"x-ms-structured-body");
    private static final HttpHeaderName X_MS_MODE = HttpHeaderName.fromString((String)"x-ms-mode");
    private static final HttpHeaderName X_MS_FILE_ATTRIBUTES = HttpHeaderName.fromString((String)"x-ms-file-attributes");
    private static final HttpHeaderName X_MS_STRUCTURED_CONTENT_LENGTH = HttpHeaderName.fromString((String)"x-ms-structured-content-length");
    private static final HttpHeaderName X_MS_COPY_STATUS_DESCRIPTION = HttpHeaderName.fromString((String)"x-ms-copy-status-description");
    private static final HttpHeaderName X_MS_LEASE_DURATION = HttpHeaderName.fromString((String)"x-ms-lease-duration");
    private static final HttpHeaderName X_MS_OWNER = HttpHeaderName.fromString((String)"x-ms-owner");
    private static final HttpHeaderName X_MS_GROUP = HttpHeaderName.fromString((String)"x-ms-group");
    private static final HttpHeaderName X_MS_VERSION = HttpHeaderName.fromString((String)"x-ms-version");
    private static final HttpHeaderName X_MS_FILE_PERMISSION_KEY = HttpHeaderName.fromString((String)"x-ms-file-permission-key");
    private static final HttpHeaderName X_MS_COPY_ID = HttpHeaderName.fromString((String)"x-ms-copy-id");
    private static final HttpHeaderName X_MS_COPY_SOURCE = HttpHeaderName.fromString((String)"x-ms-copy-source");
    private static final HttpHeaderName X_MS_COPY_PROGRESS = HttpHeaderName.fromString((String)"x-ms-copy-progress");
    private static final HttpHeaderName X_MS_COPY_COMPLETION_TIME = HttpHeaderName.fromString((String)"x-ms-copy-completion-time");
    private static final HttpHeaderName X_MS_SERVER_ENCRYPTED = HttpHeaderName.fromString((String)"x-ms-server-encrypted");
    private static final HttpHeaderName X_MS_LINK_COUNT = HttpHeaderName.fromString((String)"x-ms-link-count");
    private static final HttpHeaderName X_MS_FILE_CHANGE_TIME = HttpHeaderName.fromString((String)"x-ms-file-change-time");
    private static final HttpHeaderName X_MS_FILE_PARENT_ID = HttpHeaderName.fromString((String)"x-ms-file-parent-id");
    private static final HttpHeaderName X_MS_COPY_STATUS = HttpHeaderName.fromString((String)"x-ms-copy-status");
    private static final HttpHeaderName X_MS_FILE_LAST_WRITE_TIME = HttpHeaderName.fromString((String)"x-ms-file-last-write-time");

    public FilesDownloadHeaders(HttpHeaders rawHeaders) {
        String xMsServerEncrypted;
        String contentMD5;
        String contentLength;
        String lastModified;
        String xMsContentMd5;
        String xMsFileCreationTime;
        this.xMsFileId = rawHeaders.getValue(X_MS_FILE_ID);
        String xMsLeaseStatus = rawHeaders.getValue(X_MS_LEASE_STATUS);
        if (xMsLeaseStatus != null) {
            this.xMsLeaseStatus = LeaseStatusType.fromString(xMsLeaseStatus);
        }
        if ((xMsFileCreationTime = rawHeaders.getValue(X_MS_FILE_CREATION_TIME)) != null) {
            this.xMsFileCreationTime = OffsetDateTime.parse(xMsFileCreationTime);
        }
        this.contentRange = rawHeaders.getValue(HttpHeaderName.CONTENT_RANGE);
        String xMsLeaseState = rawHeaders.getValue(X_MS_LEASE_STATE);
        if (xMsLeaseState != null) {
            this.xMsLeaseState = LeaseStateType.fromString(xMsLeaseState);
        }
        if ((xMsContentMd5 = rawHeaders.getValue(X_MS_CONTENT_MD5)) != null) {
            this.xMsContentMd5 = Base64.getDecoder().decode(xMsContentMd5);
        }
        if ((lastModified = rawHeaders.getValue(HttpHeaderName.LAST_MODIFIED)) != null) {
            this.lastModified = new DateTimeRfc1123(lastModified);
        }
        this.xMsStructuredBody = rawHeaders.getValue(X_MS_STRUCTURED_BODY);
        this.xMsMode = rawHeaders.getValue(X_MS_MODE);
        this.xMsFileAttributes = rawHeaders.getValue(X_MS_FILE_ATTRIBUTES);
        String xMsStructuredContentLength = rawHeaders.getValue(X_MS_STRUCTURED_CONTENT_LENGTH);
        if (xMsStructuredContentLength != null) {
            this.xMsStructuredContentLength = Long.parseLong(xMsStructuredContentLength);
        }
        this.contentEncoding = rawHeaders.getValue(HttpHeaderName.CONTENT_ENCODING);
        this.xMsCopyStatusDescription = rawHeaders.getValue(X_MS_COPY_STATUS_DESCRIPTION);
        String xMsLeaseDuration = rawHeaders.getValue(X_MS_LEASE_DURATION);
        if (xMsLeaseDuration != null) {
            this.xMsLeaseDuration = LeaseDurationType.fromString(xMsLeaseDuration);
        }
        if ((contentLength = rawHeaders.getValue(HttpHeaderName.CONTENT_LENGTH)) != null) {
            this.contentLength = Long.parseLong(contentLength);
        }
        this.xMsRequestId = rawHeaders.getValue(HttpHeaderName.X_MS_REQUEST_ID);
        this.xMsOwner = rawHeaders.getValue(X_MS_OWNER);
        this.contentType = rawHeaders.getValue(HttpHeaderName.CONTENT_TYPE);
        this.xMsGroup = rawHeaders.getValue(X_MS_GROUP);
        this.xMsVersion = rawHeaders.getValue(X_MS_VERSION);
        this.xMsFilePermissionKey = rawHeaders.getValue(X_MS_FILE_PERMISSION_KEY);
        this.xMsCopyId = rawHeaders.getValue(X_MS_COPY_ID);
        this.xMsCopySource = rawHeaders.getValue(X_MS_COPY_SOURCE);
        this.xMsCopyProgress = rawHeaders.getValue(X_MS_COPY_PROGRESS);
        String date = rawHeaders.getValue(HttpHeaderName.DATE);
        if (date != null) {
            this.date = new DateTimeRfc1123(date);
        }
        if ((contentMD5 = rawHeaders.getValue(HttpHeaderName.CONTENT_MD5)) != null) {
            this.contentMD5 = Base64.getDecoder().decode(contentMD5);
        }
        this.acceptRanges = rawHeaders.getValue(HttpHeaderName.ACCEPT_RANGES);
        String xMsCopyCompletionTime = rawHeaders.getValue(X_MS_COPY_COMPLETION_TIME);
        if (xMsCopyCompletionTime != null) {
            this.xMsCopyCompletionTime = new DateTimeRfc1123(xMsCopyCompletionTime);
        }
        if ((xMsServerEncrypted = rawHeaders.getValue(X_MS_SERVER_ENCRYPTED)) != null) {
            this.xMsServerEncrypted = Boolean.parseBoolean(xMsServerEncrypted);
        }
        this.cacheControl = rawHeaders.getValue(HttpHeaderName.CACHE_CONTROL);
        this.eTag = rawHeaders.getValue(HttpHeaderName.ETAG);
        String xMsLinkCount = rawHeaders.getValue(X_MS_LINK_COUNT);
        if (xMsLinkCount != null) {
            this.xMsLinkCount = Long.parseLong(xMsLinkCount);
        }
        this.contentDisposition = rawHeaders.getValue(HttpHeaderName.CONTENT_DISPOSITION);
        String xMsFileChangeTime = rawHeaders.getValue(X_MS_FILE_CHANGE_TIME);
        if (xMsFileChangeTime != null) {
            this.xMsFileChangeTime = OffsetDateTime.parse(xMsFileChangeTime);
        }
        this.xMsFileParentId = rawHeaders.getValue(X_MS_FILE_PARENT_ID);
        String xMsCopyStatus = rawHeaders.getValue(X_MS_COPY_STATUS);
        if (xMsCopyStatus != null) {
            this.xMsCopyStatus = CopyStatusType.fromString(xMsCopyStatus);
        }
        this.contentLanguage = rawHeaders.getValue(HttpHeaderName.CONTENT_LANGUAGE);
        String xMsFileLastWriteTime = rawHeaders.getValue(X_MS_FILE_LAST_WRITE_TIME);
        if (xMsFileLastWriteTime != null) {
            this.xMsFileLastWriteTime = OffsetDateTime.parse(xMsFileLastWriteTime);
        }
        LinkedHashMap<String, String> xMsMetaHeaderCollection = new LinkedHashMap<String, String>();
        for (HttpHeader header : rawHeaders) {
            String headerName = header.getName();
            if (!headerName.startsWith("x-ms-meta-")) continue;
            xMsMetaHeaderCollection.put(headerName.substring(10), header.getValue());
        }
        this.xMsMeta = xMsMetaHeaderCollection;
    }

    public String getXMsFileId() {
        return this.xMsFileId;
    }

    public FilesDownloadHeaders setXMsFileId(String xMsFileId) {
        this.xMsFileId = xMsFileId;
        return this;
    }

    public LeaseStatusType getXMsLeaseStatus() {
        return this.xMsLeaseStatus;
    }

    public FilesDownloadHeaders setXMsLeaseStatus(LeaseStatusType xMsLeaseStatus) {
        this.xMsLeaseStatus = xMsLeaseStatus;
        return this;
    }

    public OffsetDateTime getXMsFileCreationTime() {
        return this.xMsFileCreationTime;
    }

    public FilesDownloadHeaders setXMsFileCreationTime(OffsetDateTime xMsFileCreationTime) {
        this.xMsFileCreationTime = xMsFileCreationTime;
        return this;
    }

    public String getContentRange() {
        return this.contentRange;
    }

    public FilesDownloadHeaders setContentRange(String contentRange) {
        this.contentRange = contentRange;
        return this;
    }

    public LeaseStateType getXMsLeaseState() {
        return this.xMsLeaseState;
    }

    public FilesDownloadHeaders setXMsLeaseState(LeaseStateType xMsLeaseState) {
        this.xMsLeaseState = xMsLeaseState;
        return this;
    }

    public byte[] getXMsContentMd5() {
        return CoreUtils.clone((byte[])this.xMsContentMd5);
    }

    public FilesDownloadHeaders setXMsContentMd5(byte[] xMsContentMd5) {
        this.xMsContentMd5 = CoreUtils.clone((byte[])xMsContentMd5);
        return this;
    }

    public OffsetDateTime getLastModified() {
        if (this.lastModified == null) {
            return null;
        }
        return this.lastModified.getDateTime();
    }

    public FilesDownloadHeaders setLastModified(OffsetDateTime lastModified) {
        this.lastModified = lastModified == null ? null : new DateTimeRfc1123(lastModified);
        return this;
    }

    public String getXMsStructuredBody() {
        return this.xMsStructuredBody;
    }

    public FilesDownloadHeaders setXMsStructuredBody(String xMsStructuredBody) {
        this.xMsStructuredBody = xMsStructuredBody;
        return this;
    }

    public String getXMsMode() {
        return this.xMsMode;
    }

    public FilesDownloadHeaders setXMsMode(String xMsMode) {
        this.xMsMode = xMsMode;
        return this;
    }

    public String getXMsFileAttributes() {
        return this.xMsFileAttributes;
    }

    public FilesDownloadHeaders setXMsFileAttributes(String xMsFileAttributes) {
        this.xMsFileAttributes = xMsFileAttributes;
        return this;
    }

    public Long getXMsStructuredContentLength() {
        return this.xMsStructuredContentLength;
    }

    public FilesDownloadHeaders setXMsStructuredContentLength(Long xMsStructuredContentLength) {
        this.xMsStructuredContentLength = xMsStructuredContentLength;
        return this;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public FilesDownloadHeaders setContentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
        return this;
    }

    public String getXMsCopyStatusDescription() {
        return this.xMsCopyStatusDescription;
    }

    public FilesDownloadHeaders setXMsCopyStatusDescription(String xMsCopyStatusDescription) {
        this.xMsCopyStatusDescription = xMsCopyStatusDescription;
        return this;
    }

    public LeaseDurationType getXMsLeaseDuration() {
        return this.xMsLeaseDuration;
    }

    public FilesDownloadHeaders setXMsLeaseDuration(LeaseDurationType xMsLeaseDuration) {
        this.xMsLeaseDuration = xMsLeaseDuration;
        return this;
    }

    public Long getContentLength() {
        return this.contentLength;
    }

    public FilesDownloadHeaders setContentLength(Long contentLength) {
        this.contentLength = contentLength;
        return this;
    }

    public String getXMsRequestId() {
        return this.xMsRequestId;
    }

    public FilesDownloadHeaders setXMsRequestId(String xMsRequestId) {
        this.xMsRequestId = xMsRequestId;
        return this;
    }

    public String getXMsOwner() {
        return this.xMsOwner;
    }

    public FilesDownloadHeaders setXMsOwner(String xMsOwner) {
        this.xMsOwner = xMsOwner;
        return this;
    }

    public String getContentType() {
        return this.contentType;
    }

    public FilesDownloadHeaders setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public String getXMsGroup() {
        return this.xMsGroup;
    }

    public FilesDownloadHeaders setXMsGroup(String xMsGroup) {
        this.xMsGroup = xMsGroup;
        return this;
    }

    public String getXMsVersion() {
        return this.xMsVersion;
    }

    public FilesDownloadHeaders setXMsVersion(String xMsVersion) {
        this.xMsVersion = xMsVersion;
        return this;
    }

    public String getXMsFilePermissionKey() {
        return this.xMsFilePermissionKey;
    }

    public FilesDownloadHeaders setXMsFilePermissionKey(String xMsFilePermissionKey) {
        this.xMsFilePermissionKey = xMsFilePermissionKey;
        return this;
    }

    public String getXMsCopyId() {
        return this.xMsCopyId;
    }

    public FilesDownloadHeaders setXMsCopyId(String xMsCopyId) {
        this.xMsCopyId = xMsCopyId;
        return this;
    }

    public String getXMsCopySource() {
        return this.xMsCopySource;
    }

    public FilesDownloadHeaders setXMsCopySource(String xMsCopySource) {
        this.xMsCopySource = xMsCopySource;
        return this;
    }

    public String getXMsCopyProgress() {
        return this.xMsCopyProgress;
    }

    public FilesDownloadHeaders setXMsCopyProgress(String xMsCopyProgress) {
        this.xMsCopyProgress = xMsCopyProgress;
        return this;
    }

    public Map<String, String> getXMsMeta() {
        return this.xMsMeta;
    }

    public FilesDownloadHeaders setXMsMeta(Map<String, String> xMsMeta) {
        this.xMsMeta = xMsMeta;
        return this;
    }

    public OffsetDateTime getDate() {
        if (this.date == null) {
            return null;
        }
        return this.date.getDateTime();
    }

    public FilesDownloadHeaders setDate(OffsetDateTime date) {
        this.date = date == null ? null : new DateTimeRfc1123(date);
        return this;
    }

    public byte[] getContentMD5() {
        return CoreUtils.clone((byte[])this.contentMD5);
    }

    public FilesDownloadHeaders setContentMD5(byte[] contentMD5) {
        this.contentMD5 = CoreUtils.clone((byte[])contentMD5);
        return this;
    }

    public String getAcceptRanges() {
        return this.acceptRanges;
    }

    public FilesDownloadHeaders setAcceptRanges(String acceptRanges) {
        this.acceptRanges = acceptRanges;
        return this;
    }

    public OffsetDateTime getXMsCopyCompletionTime() {
        if (this.xMsCopyCompletionTime == null) {
            return null;
        }
        return this.xMsCopyCompletionTime.getDateTime();
    }

    public FilesDownloadHeaders setXMsCopyCompletionTime(OffsetDateTime xMsCopyCompletionTime) {
        this.xMsCopyCompletionTime = xMsCopyCompletionTime == null ? null : new DateTimeRfc1123(xMsCopyCompletionTime);
        return this;
    }

    public Boolean isXMsServerEncrypted() {
        return this.xMsServerEncrypted;
    }

    public FilesDownloadHeaders setXMsServerEncrypted(Boolean xMsServerEncrypted) {
        this.xMsServerEncrypted = xMsServerEncrypted;
        return this;
    }

    public String getCacheControl() {
        return this.cacheControl;
    }

    public FilesDownloadHeaders setCacheControl(String cacheControl) {
        this.cacheControl = cacheControl;
        return this;
    }

    public String getETag() {
        return this.eTag;
    }

    public FilesDownloadHeaders setETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    public Long getXMsLinkCount() {
        return this.xMsLinkCount;
    }

    public FilesDownloadHeaders setXMsLinkCount(Long xMsLinkCount) {
        this.xMsLinkCount = xMsLinkCount;
        return this;
    }

    public String getContentDisposition() {
        return this.contentDisposition;
    }

    public FilesDownloadHeaders setContentDisposition(String contentDisposition) {
        this.contentDisposition = contentDisposition;
        return this;
    }

    public OffsetDateTime getXMsFileChangeTime() {
        return this.xMsFileChangeTime;
    }

    public FilesDownloadHeaders setXMsFileChangeTime(OffsetDateTime xMsFileChangeTime) {
        this.xMsFileChangeTime = xMsFileChangeTime;
        return this;
    }

    public String getXMsFileParentId() {
        return this.xMsFileParentId;
    }

    public FilesDownloadHeaders setXMsFileParentId(String xMsFileParentId) {
        this.xMsFileParentId = xMsFileParentId;
        return this;
    }

    public CopyStatusType getXMsCopyStatus() {
        return this.xMsCopyStatus;
    }

    public FilesDownloadHeaders setXMsCopyStatus(CopyStatusType xMsCopyStatus) {
        this.xMsCopyStatus = xMsCopyStatus;
        return this;
    }

    public String getContentLanguage() {
        return this.contentLanguage;
    }

    public FilesDownloadHeaders setContentLanguage(String contentLanguage) {
        this.contentLanguage = contentLanguage;
        return this;
    }

    public OffsetDateTime getXMsFileLastWriteTime() {
        return this.xMsFileLastWriteTime;
    }

    public FilesDownloadHeaders setXMsFileLastWriteTime(OffsetDateTime xMsFileLastWriteTime) {
        this.xMsFileLastWriteTime = xMsFileLastWriteTime;
        return this;
    }
}

