/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.implementation.models;

import com.azure.core.util.DateTimeRfc1123;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.time.OffsetDateTime;

@JacksonXmlRootElement(localName="PageBlob-Resize-Headers")
public final class PageBlobResizeHeaders {
    @JsonProperty(value="ETag")
    private String eTag;
    @JsonProperty(value="Last-Modified")
    private DateTimeRfc1123 lastModified;
    @JsonProperty(value="x-ms-blob-sequence-number")
    private Long blobSequenceNumber;
    @JsonProperty(value="x-ms-client-request-id")
    private String clientRequestId;
    @JsonProperty(value="x-ms-request-id")
    private String requestId;
    @JsonProperty(value="x-ms-version")
    private String version;
    @JsonProperty(value="Date")
    private DateTimeRfc1123 dateProperty;
    @JsonProperty(value="x-ms-error-code")
    private String errorCode;

    public String getETag() {
        return this.eTag;
    }

    public PageBlobResizeHeaders setETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    public OffsetDateTime getLastModified() {
        if (this.lastModified == null) {
            return null;
        }
        return this.lastModified.getDateTime();
    }

    public PageBlobResizeHeaders setLastModified(OffsetDateTime lastModified) {
        this.lastModified = lastModified == null ? null : new DateTimeRfc1123(lastModified);
        return this;
    }

    public Long getBlobSequenceNumber() {
        return this.blobSequenceNumber;
    }

    public PageBlobResizeHeaders setBlobSequenceNumber(Long blobSequenceNumber) {
        this.blobSequenceNumber = blobSequenceNumber;
        return this;
    }

    public String getClientRequestId() {
        return this.clientRequestId;
    }

    public PageBlobResizeHeaders setClientRequestId(String clientRequestId) {
        this.clientRequestId = clientRequestId;
        return this;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public PageBlobResizeHeaders setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public PageBlobResizeHeaders setVersion(String version) {
        this.version = version;
        return this;
    }

    public OffsetDateTime getDateProperty() {
        if (this.dateProperty == null) {
            return null;
        }
        return this.dateProperty.getDateTime();
    }

    public PageBlobResizeHeaders setDateProperty(OffsetDateTime dateProperty) {
        this.dateProperty = dateProperty == null ? null : new DateTimeRfc1123(dateProperty);
        return this;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public PageBlobResizeHeaders setErrorCode(String errorCode) {
        this.errorCode = errorCode;
        return this;
    }
}

