package com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.openssl.jcajce;

import java.security.PrivateKey;

import com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.openssl.PKCS8Generator;
import com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.operator.OutputEncryptor;
import com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.util.io.pem.PemGenerationException;

public class JcaPKCS8Generator
    extends PKCS8Generator
{
    public JcaPKCS8Generator(PrivateKey key, OutputEncryptor encryptor)
         throws PemGenerationException
    {
         super(PrivateKeyInfo.getInstance(key.getEncoded()), encryptor);
    }
}
