package com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.crypto.digests;

import com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.crypto.CryptoServiceProperties;
import com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.crypto.CryptoServicePurpose;
import com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.crypto.CryptoServicesRegistrar;
import com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.crypto.Digest;

/**
 * Base native digest provides constraint verification for native digests.
 */
public abstract class BaseNativeDigest implements Digest
{
    private final CryptoServicePurpose purpose;
    private final int bitLen;

    public BaseNativeDigest(int bitLen, CryptoServicePurpose purpose)
    {
        this.purpose = purpose;
        this.bitLen = bitLen;
        CryptoServicesRegistrar.checkConstraints(cryptoServiceProperties());
    }

    protected final CryptoServiceProperties cryptoServiceProperties()
    {
        return Utils.getDefaultProperties(this, bitLen, purpose);
    }
}
