/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.administration.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.security.keyvault.administration.implementation.KeyVaultAccessControlClientImpl;
import com.azure.security.keyvault.administration.implementation.models.KeyVaultErrorException;
import com.azure.security.keyvault.administration.implementation.models.RoleAssignment;
import com.azure.security.keyvault.administration.implementation.models.RoleAssignmentCreateParameters;
import com.azure.security.keyvault.administration.implementation.models.RoleAssignmentListResult;
import reactor.core.publisher.Mono;

public final class RoleAssignmentsImpl {
    private final RoleAssignmentsService service;
    private final KeyVaultAccessControlClientImpl client;

    RoleAssignmentsImpl(KeyVaultAccessControlClientImpl client) {
        this.service = (RoleAssignmentsService)RestProxy.create(RoleAssignmentsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RoleAssignment>> deleteWithResponseAsync(String vaultBaseUrl, String scope, String roleAssignmentName) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(vaultBaseUrl, scope, roleAssignmentName, this.client.getApiVersion(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RoleAssignment>> deleteWithResponseAsync(String vaultBaseUrl, String scope, String roleAssignmentName, Context context) {
        String accept = "application/json";
        return this.service.delete(vaultBaseUrl, scope, roleAssignmentName, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RoleAssignment> deleteAsync(String vaultBaseUrl, String scope, String roleAssignmentName) {
        return this.deleteWithResponseAsync(vaultBaseUrl, scope, roleAssignmentName).flatMap(res -> Mono.justOrEmpty((Object)((RoleAssignment)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RoleAssignment> deleteAsync(String vaultBaseUrl, String scope, String roleAssignmentName, Context context) {
        return this.deleteWithResponseAsync(vaultBaseUrl, scope, roleAssignmentName, context).flatMap(res -> Mono.justOrEmpty((Object)((RoleAssignment)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RoleAssignment> deleteWithResponse(String vaultBaseUrl, String scope, String roleAssignmentName, Context context) {
        String accept = "application/json";
        return this.service.deleteSync(vaultBaseUrl, scope, roleAssignmentName, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public RoleAssignment delete(String vaultBaseUrl, String scope, String roleAssignmentName) {
        return (RoleAssignment)this.deleteWithResponse(vaultBaseUrl, scope, roleAssignmentName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RoleAssignment>> createWithResponseAsync(String vaultBaseUrl, String scope, String roleAssignmentName, RoleAssignmentCreateParameters parameters) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.create(vaultBaseUrl, scope, roleAssignmentName, this.client.getApiVersion(), parameters, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RoleAssignment>> createWithResponseAsync(String vaultBaseUrl, String scope, String roleAssignmentName, RoleAssignmentCreateParameters parameters, Context context) {
        String accept = "application/json";
        return this.service.create(vaultBaseUrl, scope, roleAssignmentName, this.client.getApiVersion(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RoleAssignment> createAsync(String vaultBaseUrl, String scope, String roleAssignmentName, RoleAssignmentCreateParameters parameters) {
        return this.createWithResponseAsync(vaultBaseUrl, scope, roleAssignmentName, parameters).flatMap(res -> Mono.justOrEmpty((Object)((RoleAssignment)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RoleAssignment> createAsync(String vaultBaseUrl, String scope, String roleAssignmentName, RoleAssignmentCreateParameters parameters, Context context) {
        return this.createWithResponseAsync(vaultBaseUrl, scope, roleAssignmentName, parameters, context).flatMap(res -> Mono.justOrEmpty((Object)((RoleAssignment)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RoleAssignment> createWithResponse(String vaultBaseUrl, String scope, String roleAssignmentName, RoleAssignmentCreateParameters parameters, Context context) {
        String accept = "application/json";
        return this.service.createSync(vaultBaseUrl, scope, roleAssignmentName, this.client.getApiVersion(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public RoleAssignment create(String vaultBaseUrl, String scope, String roleAssignmentName, RoleAssignmentCreateParameters parameters) {
        return (RoleAssignment)this.createWithResponse(vaultBaseUrl, scope, roleAssignmentName, parameters, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RoleAssignment>> getWithResponseAsync(String vaultBaseUrl, String scope, String roleAssignmentName) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(vaultBaseUrl, scope, roleAssignmentName, this.client.getApiVersion(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RoleAssignment>> getWithResponseAsync(String vaultBaseUrl, String scope, String roleAssignmentName, Context context) {
        String accept = "application/json";
        return this.service.get(vaultBaseUrl, scope, roleAssignmentName, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RoleAssignment> getAsync(String vaultBaseUrl, String scope, String roleAssignmentName) {
        return this.getWithResponseAsync(vaultBaseUrl, scope, roleAssignmentName).flatMap(res -> Mono.justOrEmpty((Object)((RoleAssignment)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RoleAssignment> getAsync(String vaultBaseUrl, String scope, String roleAssignmentName, Context context) {
        return this.getWithResponseAsync(vaultBaseUrl, scope, roleAssignmentName, context).flatMap(res -> Mono.justOrEmpty((Object)((RoleAssignment)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RoleAssignment> getWithResponse(String vaultBaseUrl, String scope, String roleAssignmentName, Context context) {
        String accept = "application/json";
        return this.service.getSync(vaultBaseUrl, scope, roleAssignmentName, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public RoleAssignment get(String vaultBaseUrl, String scope, String roleAssignmentName) {
        return (RoleAssignment)this.getWithResponse(vaultBaseUrl, scope, roleAssignmentName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<RoleAssignment>> listForScopeSinglePageAsync(String vaultBaseUrl, String scope, String filter) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listForScope(vaultBaseUrl, scope, filter, this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RoleAssignmentListResult)res.getValue()).getValue(), ((RoleAssignmentListResult)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<RoleAssignment>> listForScopeSinglePageAsync(String vaultBaseUrl, String scope, String filter, Context context) {
        String accept = "application/json";
        return this.service.listForScope(vaultBaseUrl, scope, filter, this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RoleAssignmentListResult)res.getValue()).getValue(), ((RoleAssignmentListResult)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<RoleAssignment> listForScopeAsync(String vaultBaseUrl, String scope, String filter) {
        return new PagedFlux(() -> this.listForScopeSinglePageAsync(vaultBaseUrl, scope, filter), nextLink -> this.listForScopeNextSinglePageAsync((String)nextLink, vaultBaseUrl));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<RoleAssignment> listForScopeAsync(String vaultBaseUrl, String scope, String filter, Context context) {
        return new PagedFlux(() -> this.listForScopeSinglePageAsync(vaultBaseUrl, scope, filter, context), nextLink -> this.listForScopeNextSinglePageAsync((String)nextLink, vaultBaseUrl, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<RoleAssignment> listForScopeSinglePage(String vaultBaseUrl, String scope, String filter) {
        String accept = "application/json";
        Response<RoleAssignmentListResult> res = this.service.listForScopeSync(vaultBaseUrl, scope, filter, this.client.getApiVersion(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RoleAssignmentListResult)res.getValue()).getValue(), ((RoleAssignmentListResult)res.getValue()).getNextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<RoleAssignment> listForScopeSinglePage(String vaultBaseUrl, String scope, String filter, Context context) {
        String accept = "application/json";
        Response<RoleAssignmentListResult> res = this.service.listForScopeSync(vaultBaseUrl, scope, filter, this.client.getApiVersion(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RoleAssignmentListResult)res.getValue()).getValue(), ((RoleAssignmentListResult)res.getValue()).getNextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RoleAssignment> listForScope(String vaultBaseUrl, String scope, String filter) {
        return new PagedIterable(() -> this.listForScopeSinglePage(vaultBaseUrl, scope, filter, Context.NONE), nextLink -> this.listForScopeNextSinglePage((String)nextLink, vaultBaseUrl));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RoleAssignment> listForScope(String vaultBaseUrl, String scope, String filter, Context context) {
        return new PagedIterable(() -> this.listForScopeSinglePage(vaultBaseUrl, scope, filter, context), nextLink -> this.listForScopeNextSinglePage((String)nextLink, vaultBaseUrl, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<RoleAssignment>> listForScopeNextSinglePageAsync(String nextLink, String vaultBaseUrl) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listForScopeNext(nextLink, vaultBaseUrl, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RoleAssignmentListResult)res.getValue()).getValue(), ((RoleAssignmentListResult)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<RoleAssignment>> listForScopeNextSinglePageAsync(String nextLink, String vaultBaseUrl, Context context) {
        String accept = "application/json";
        return this.service.listForScopeNext(nextLink, vaultBaseUrl, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RoleAssignmentListResult)res.getValue()).getValue(), ((RoleAssignmentListResult)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<RoleAssignment> listForScopeNextSinglePage(String nextLink, String vaultBaseUrl) {
        String accept = "application/json";
        Response<RoleAssignmentListResult> res = this.service.listForScopeNextSync(nextLink, vaultBaseUrl, "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RoleAssignmentListResult)res.getValue()).getValue(), ((RoleAssignmentListResult)res.getValue()).getNextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<RoleAssignment> listForScopeNextSinglePage(String nextLink, String vaultBaseUrl, Context context) {
        String accept = "application/json";
        Response<RoleAssignmentListResult> res = this.service.listForScopeNextSync(nextLink, vaultBaseUrl, "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RoleAssignmentListResult)res.getValue()).getValue(), ((RoleAssignmentListResult)res.getValue()).getNextLink(), null);
    }

    @Host(value="{vaultBaseUrl}")
    @ServiceInterface(name="KeyVaultAccessContro")
    public static interface RoleAssignmentsService {
        @Delete(value="/{scope}/providers/Microsoft.Authorization/roleAssignments/{roleAssignmentName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<RoleAssignment>> delete(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="scope", encoded=true) String var2, @PathParam(value="roleAssignmentName") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Delete(value="/{scope}/providers/Microsoft.Authorization/roleAssignments/{roleAssignmentName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<RoleAssignment> deleteSync(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="scope", encoded=true) String var2, @PathParam(value="roleAssignmentName") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Put(value="/{scope}/providers/Microsoft.Authorization/roleAssignments/{roleAssignmentName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<RoleAssignment>> create(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="scope", encoded=true) String var2, @PathParam(value="roleAssignmentName") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") RoleAssignmentCreateParameters var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Put(value="/{scope}/providers/Microsoft.Authorization/roleAssignments/{roleAssignmentName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<RoleAssignment> createSync(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="scope", encoded=true) String var2, @PathParam(value="roleAssignmentName") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") RoleAssignmentCreateParameters var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Get(value="/{scope}/providers/Microsoft.Authorization/roleAssignments/{roleAssignmentName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<RoleAssignment>> get(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="scope", encoded=true) String var2, @PathParam(value="roleAssignmentName") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="/{scope}/providers/Microsoft.Authorization/roleAssignments/{roleAssignmentName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<RoleAssignment> getSync(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="scope", encoded=true) String var2, @PathParam(value="roleAssignmentName") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="/{scope}/providers/Microsoft.Authorization/roleAssignments")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<RoleAssignmentListResult>> listForScope(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="scope", encoded=true) String var2, @QueryParam(value="$filter") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="/{scope}/providers/Microsoft.Authorization/roleAssignments")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<RoleAssignmentListResult> listForScopeSync(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="scope", encoded=true) String var2, @QueryParam(value="$filter") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<RoleAssignmentListResult>> listForScopeNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="vaultBaseUrl") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<RoleAssignmentListResult> listForScopeNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="vaultBaseUrl") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

