/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.administration.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.CookiePolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.security.keyvault.administration.implementation.models.KeyVaultErrorException;
import com.azure.security.keyvault.administration.implementation.models.Setting;
import com.azure.security.keyvault.administration.implementation.models.SettingsListResult;
import com.azure.security.keyvault.administration.implementation.models.UpdateSettingRequest;
import reactor.core.publisher.Mono;

public final class KeyVaultSettingsClientImpl {
    private final KeyVaultSettingsClientService service;
    private final String apiVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;

    public String getApiVersion() {
        return this.apiVersion;
    }

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    KeyVaultSettingsClientImpl(String apiVersion) {
        this(new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy(), new CookiePolicy()}).build(), JacksonAdapter.createDefaultSerializerAdapter(), apiVersion);
    }

    KeyVaultSettingsClientImpl(HttpPipeline httpPipeline, String apiVersion) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), apiVersion);
    }

    KeyVaultSettingsClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String apiVersion) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.apiVersion = apiVersion;
        this.service = (KeyVaultSettingsClientService)RestProxy.create(KeyVaultSettingsClientService.class, (HttpPipeline)this.httpPipeline, (SerializerAdapter)this.getSerializerAdapter());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Setting>> updateSettingWithResponseAsync(String vaultBaseUrl, String settingName, String value) {
        String accept = "application/json";
        UpdateSettingRequest parameters = new UpdateSettingRequest();
        parameters.setValue(value);
        return FluxUtil.withContext(context -> this.service.updateSetting(vaultBaseUrl, settingName, this.getApiVersion(), parameters, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Setting>> updateSettingWithResponseAsync(String vaultBaseUrl, String settingName, String value, Context context) {
        String accept = "application/json";
        UpdateSettingRequest parameters = new UpdateSettingRequest();
        parameters.setValue(value);
        return this.service.updateSetting(vaultBaseUrl, settingName, this.getApiVersion(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Setting> updateSettingAsync(String vaultBaseUrl, String settingName, String value) {
        return this.updateSettingWithResponseAsync(vaultBaseUrl, settingName, value).flatMap(res -> Mono.justOrEmpty((Object)((Setting)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Setting> updateSettingAsync(String vaultBaseUrl, String settingName, String value, Context context) {
        return this.updateSettingWithResponseAsync(vaultBaseUrl, settingName, value, context).flatMap(res -> Mono.justOrEmpty((Object)((Setting)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Setting> updateSettingWithResponse(String vaultBaseUrl, String settingName, String value, Context context) {
        String accept = "application/json";
        UpdateSettingRequest parameters = new UpdateSettingRequest();
        parameters.setValue(value);
        return this.service.updateSettingSync(vaultBaseUrl, settingName, this.getApiVersion(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Setting updateSetting(String vaultBaseUrl, String settingName, String value) {
        return (Setting)this.updateSettingWithResponse(vaultBaseUrl, settingName, value, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Setting>> getSettingWithResponseAsync(String vaultBaseUrl, String settingName) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getSetting(vaultBaseUrl, settingName, this.getApiVersion(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Setting>> getSettingWithResponseAsync(String vaultBaseUrl, String settingName, Context context) {
        String accept = "application/json";
        return this.service.getSetting(vaultBaseUrl, settingName, this.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Setting> getSettingAsync(String vaultBaseUrl, String settingName) {
        return this.getSettingWithResponseAsync(vaultBaseUrl, settingName).flatMap(res -> Mono.justOrEmpty((Object)((Setting)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Setting> getSettingAsync(String vaultBaseUrl, String settingName, Context context) {
        return this.getSettingWithResponseAsync(vaultBaseUrl, settingName, context).flatMap(res -> Mono.justOrEmpty((Object)((Setting)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Setting> getSettingWithResponse(String vaultBaseUrl, String settingName, Context context) {
        String accept = "application/json";
        return this.service.getSettingSync(vaultBaseUrl, settingName, this.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Setting getSetting(String vaultBaseUrl, String settingName) {
        return (Setting)this.getSettingWithResponse(vaultBaseUrl, settingName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SettingsListResult>> getSettingsWithResponseAsync(String vaultBaseUrl) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getSettings(vaultBaseUrl, this.getApiVersion(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SettingsListResult>> getSettingsWithResponseAsync(String vaultBaseUrl, Context context) {
        String accept = "application/json";
        return this.service.getSettings(vaultBaseUrl, this.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SettingsListResult> getSettingsAsync(String vaultBaseUrl) {
        return this.getSettingsWithResponseAsync(vaultBaseUrl).flatMap(res -> Mono.justOrEmpty((Object)((SettingsListResult)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SettingsListResult> getSettingsAsync(String vaultBaseUrl, Context context) {
        return this.getSettingsWithResponseAsync(vaultBaseUrl, context).flatMap(res -> Mono.justOrEmpty((Object)((SettingsListResult)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SettingsListResult> getSettingsWithResponse(String vaultBaseUrl, Context context) {
        String accept = "application/json";
        return this.service.getSettingsSync(vaultBaseUrl, this.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SettingsListResult getSettings(String vaultBaseUrl) {
        return (SettingsListResult)this.getSettingsWithResponse(vaultBaseUrl, Context.NONE).getValue();
    }

    @Host(value="{vaultBaseUrl}")
    @ServiceInterface(name="KeyVaultSettingsClie")
    public static interface KeyVaultSettingsClientService {
        @Patch(value="/settings/{setting-name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<Setting>> updateSetting(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="setting-name") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") UpdateSettingRequest var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Patch(value="/settings/{setting-name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<Setting> updateSettingSync(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="setting-name") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") UpdateSettingRequest var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="/settings/{setting-name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<Setting>> getSetting(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="setting-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="/settings/{setting-name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<Setting> getSettingSync(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="setting-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="/settings")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<SettingsListResult>> getSettings(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Get(value="/settings")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<SettingsListResult> getSettingsSync(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

