/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.administration.implementation;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class KeyVaultErrorCodeStrings {
    static final String ERROR_STRINGS_FILE_NAME = "kvErrorStrings.properties";
    private static Properties errorStrings;
    public static final String CREDENTIAL_REQUIRED = "credential_required";
    public static final String VAULT_END_POINT_REQUIRED = "vault_endpoint_required";
    public static final String PARAMETER_REQUIRED = "parameter_required";

    public static String getErrorString(String propertyName) {
        KeyVaultErrorCodeStrings.loadProperties();
        return errorStrings.getProperty(propertyName);
    }

    private static synchronized void loadProperties() {
        if (errorStrings == null) {
            try (InputStream fileInputStream = KeyVaultErrorCodeStrings.class.getClassLoader().getResource(ERROR_STRINGS_FILE_NAME).openStream();){
                errorStrings = new Properties();
                errorStrings.load(fileInputStream);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }
}

