/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.administration;

import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.client.traits.ConfigurationTrait;
import com.azure.core.client.traits.HttpTrait;
import com.azure.core.client.traits.TokenCredentialTrait;
import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.HttpPipelinePosition;
import com.azure.core.http.policy.AddDatePolicy;
import com.azure.core.http.policy.AddHeadersFromContextPolicy;
import com.azure.core.http.policy.AddHeadersPolicy;
import com.azure.core.http.policy.CookiePolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPolicyProviders;
import com.azure.core.http.policy.RequestIdPolicy;
import com.azure.core.http.policy.RetryOptions;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.TracingOptions;
import com.azure.core.util.builder.ClientBuilderUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.tracing.Tracer;
import com.azure.core.util.tracing.TracerProvider;
import com.azure.security.keyvault.administration.KeyVaultAdministrationServiceVersion;
import com.azure.security.keyvault.administration.KeyVaultSettingsAsyncClient;
import com.azure.security.keyvault.administration.KeyVaultSettingsClient;
import com.azure.security.keyvault.administration.implementation.KeyVaultCredentialPolicy;
import com.azure.security.keyvault.administration.implementation.KeyVaultErrorCodeStrings;
import com.azure.security.keyvault.administration.implementation.KeyVaultSettingsClientImpl;
import com.azure.security.keyvault.administration.implementation.KeyVaultSettingsClientImplBuilder;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@ServiceClientBuilder(serviceClients={KeyVaultSettingsClient.class, KeyVaultSettingsAsyncClient.class})
public final class KeyVaultSettingsClientBuilder
implements TokenCredentialTrait<KeyVaultSettingsClientBuilder>,
HttpTrait<KeyVaultSettingsClientBuilder>,
ConfigurationTrait<KeyVaultSettingsClientBuilder> {
    private static final ClientLogger LOGGER = new ClientLogger(KeyVaultSettingsClientBuilder.class);
    private static final String AZURE_KEY_VAULT_RBAC = "azure-key-vault-administration.properties";
    private static final String SDK_NAME = "name";
    private static final String SDK_VERSION = "version";
    private static final String KEYVAULT_TRACING_NAMESPACE_VALUE = "Microsoft.KeyVault";
    private final KeyVaultSettingsClientImplBuilder implClientBuilder;
    private final List<HttpPipelinePolicy> pipelinePolicies;
    private final Map<String, String> properties;
    private TokenCredential credential;
    private HttpPipeline pipeline;
    private String vaultUrl;
    private HttpClient httpClient;
    private HttpLogOptions httpLogOptions = new HttpLogOptions();
    private RetryPolicy retryPolicy;
    private RetryOptions retryOptions;
    private Configuration configuration;
    private ClientOptions clientOptions;
    private KeyVaultAdministrationServiceVersion serviceVersion;
    private boolean disableChallengeResourceVerification = false;

    public KeyVaultSettingsClientBuilder() {
        this.pipelinePolicies = new ArrayList<HttpPipelinePolicy>();
        this.properties = CoreUtils.getProperties((String)AZURE_KEY_VAULT_RBAC);
        this.implClientBuilder = new KeyVaultSettingsClientImplBuilder();
    }

    public KeyVaultSettingsClientBuilder vaultUrl(String vaultUrl) {
        if (vaultUrl == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException("'vaultUrl' cannot be null."));
        }
        try {
            URL url = new URL(vaultUrl);
            this.vaultUrl = url.toString();
        }
        catch (MalformedURLException e) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("The Azure Key Vault URL is malformed.", e));
        }
        return this;
    }

    public KeyVaultSettingsClientBuilder credential(TokenCredential credential) {
        if (credential == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException("'credential' cannot be null."));
        }
        this.credential = credential;
        return this;
    }

    public KeyVaultSettingsClientBuilder pipeline(HttpPipeline pipeline) {
        this.pipeline = pipeline;
        return this;
    }

    public KeyVaultSettingsClientBuilder httpClient(HttpClient client) {
        this.httpClient = client;
        return this;
    }

    public KeyVaultSettingsClientBuilder httpLogOptions(HttpLogOptions logOptions) {
        this.httpLogOptions = logOptions;
        return this;
    }

    public KeyVaultSettingsClientBuilder clientOptions(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        return this;
    }

    public KeyVaultSettingsClientBuilder retryOptions(RetryOptions retryOptions) {
        this.retryOptions = retryOptions;
        return this;
    }

    public KeyVaultSettingsClientBuilder addPolicy(HttpPipelinePolicy policy) {
        if (policy == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException("'policy' cannot be null."));
        }
        this.pipelinePolicies.add(policy);
        return this;
    }

    public KeyVaultSettingsClientBuilder configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public KeyVaultSettingsClientBuilder serviceVersion(KeyVaultAdministrationServiceVersion serviceVersion) {
        this.serviceVersion = serviceVersion;
        return this;
    }

    public KeyVaultSettingsClientBuilder retryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    public KeyVaultSettingsClientBuilder disableChallengeResourceVerification() {
        this.disableChallengeResourceVerification = true;
        return this;
    }

    private KeyVaultSettingsClientImpl buildImplClient() {
        return this.implClientBuilder.pipeline(this.pipeline != null ? this.pipeline : this.createHttpPipeline()).buildClient();
    }

    private HttpPipeline createHttpPipeline() {
        Configuration buildConfiguration;
        if (this.pipeline != null) {
            return this.pipeline;
        }
        Configuration configuration = buildConfiguration = this.configuration == null ? Configuration.getGlobalConfiguration() : this.configuration;
        if (this.vaultUrl == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException(KeyVaultErrorCodeStrings.getErrorString("vault_endpoint_required")));
        }
        this.serviceVersion = this.serviceVersion != null ? this.serviceVersion : KeyVaultAdministrationServiceVersion.getLatest();
        ArrayList<Object> policies = new ArrayList<Object>();
        String clientName = this.properties.getOrDefault(SDK_NAME, "UnknownName");
        String clientVersion = this.properties.getOrDefault(SDK_VERSION, "UnknownVersion");
        this.httpLogOptions = this.httpLogOptions == null ? new HttpLogOptions() : this.httpLogOptions;
        String applicationId = CoreUtils.getApplicationId((ClientOptions)this.clientOptions, (HttpLogOptions)this.httpLogOptions);
        policies.add(new UserAgentPolicy(applicationId, clientName, clientVersion, buildConfiguration));
        policies.add(new RequestIdPolicy());
        policies.add(new AddHeadersFromContextPolicy());
        if (this.clientOptions != null) {
            HttpHeaders headers = new HttpHeaders();
            this.clientOptions.getHeaders().forEach(header -> headers.set(header.getName(), header.getValue()));
            if (headers.getSize() > 0) {
                policies.add(new AddHeadersPolicy(headers));
            }
        }
        policies.addAll(this.pipelinePolicies.stream().filter(p -> p.getPipelinePosition() == HttpPipelinePosition.PER_CALL).collect(Collectors.toList()));
        HttpPolicyProviders.addBeforeRetryPolicies(policies);
        policies.add(ClientBuilderUtil.validateAndGetRetryPolicy((HttpPipelinePolicy)this.retryPolicy, (RetryOptions)this.retryOptions, (HttpPipelinePolicy)new RetryPolicy()));
        policies.add((Object)new KeyVaultCredentialPolicy(this.credential, this.disableChallengeResourceVerification));
        policies.add(new AddDatePolicy());
        policies.add(new CookiePolicy());
        policies.addAll(this.pipelinePolicies.stream().filter(p -> p.getPipelinePosition() == HttpPipelinePosition.PER_RETRY).collect(Collectors.toList()));
        HttpPolicyProviders.addAfterRetryPolicies(policies);
        policies.add(new HttpLoggingPolicy(this.httpLogOptions));
        TracingOptions tracingOptions = this.clientOptions == null ? null : this.clientOptions.getTracingOptions();
        Tracer tracer = TracerProvider.getDefaultProvider().createTracer(clientName, clientVersion, KEYVAULT_TRACING_NAMESPACE_VALUE, tracingOptions);
        return new HttpPipelineBuilder().policies(policies.toArray(new HttpPipelinePolicy[0])).httpClient(this.httpClient).clientOptions(this.clientOptions).tracer(tracer).build();
    }

    public KeyVaultSettingsAsyncClient buildAsyncClient() {
        return new KeyVaultSettingsAsyncClient(this.vaultUrl, this.buildImplClient());
    }

    public KeyVaultSettingsClient buildClient() {
        return new KeyVaultSettingsClient(this.vaultUrl, this.buildImplClient());
    }
}

