/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.administration;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.security.keyvault.administration.KeyVaultAccessControlClientBuilder;
import com.azure.security.keyvault.administration.KeyVaultAdministrationServiceVersion;
import com.azure.security.keyvault.administration.KeyVaultAdministrationUtil;
import com.azure.security.keyvault.administration.implementation.KeyVaultAccessControlClientImpl;
import com.azure.security.keyvault.administration.implementation.KeyVaultAccessControlClientImplBuilder;
import com.azure.security.keyvault.administration.implementation.KeyVaultAdministrationUtils;
import com.azure.security.keyvault.administration.implementation.KeyVaultErrorCodeStrings;
import com.azure.security.keyvault.administration.implementation.models.KeyVaultErrorException;
import com.azure.security.keyvault.administration.implementation.models.RoleAssignment;
import com.azure.security.keyvault.administration.implementation.models.RoleAssignmentCreateParameters;
import com.azure.security.keyvault.administration.implementation.models.RoleDefinition;
import com.azure.security.keyvault.administration.implementation.models.RoleDefinitionCreateParameters;
import com.azure.security.keyvault.administration.models.KeyVaultAdministrationException;
import com.azure.security.keyvault.administration.models.KeyVaultRoleAssignment;
import com.azure.security.keyvault.administration.models.KeyVaultRoleDefinition;
import com.azure.security.keyvault.administration.models.KeyVaultRoleScope;
import com.azure.security.keyvault.administration.models.SetRoleDefinitionOptions;
import java.net.URL;
import java.util.Objects;
import java.util.UUID;

@ServiceClient(builder=KeyVaultAccessControlClientBuilder.class)
public final class KeyVaultAccessControlClient {
    private static final ClientLogger LOGGER = new ClientLogger(KeyVaultAccessControlClient.class);
    private final KeyVaultAccessControlClientImpl clientImpl;
    private final String vaultUrl;
    private final String serviceVersion;
    private final HttpPipeline pipeline;

    KeyVaultAccessControlClient(URL vaultUrl, HttpPipeline httpPipeline, KeyVaultAdministrationServiceVersion serviceVersion) {
        Objects.requireNonNull(vaultUrl, KeyVaultErrorCodeStrings.getErrorString("vault_endpoint_required"));
        this.vaultUrl = vaultUrl.toString();
        this.serviceVersion = serviceVersion.getVersion();
        this.pipeline = httpPipeline;
        this.clientImpl = new KeyVaultAccessControlClientImplBuilder().pipeline(httpPipeline).apiVersion(this.serviceVersion).buildClient();
    }

    public String getVaultUrl() {
        return this.vaultUrl;
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<KeyVaultRoleDefinition> listRoleDefinitions(KeyVaultRoleScope roleScope) {
        return this.listRoleDefinitions(roleScope, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<KeyVaultRoleDefinition> listRoleDefinitions(KeyVaultRoleScope roleScope, Context context) {
        Context contextToUse = KeyVaultAdministrationUtil.enableSyncRestProxy(context);
        return new PagedIterable(() -> this.listRoleDefinitionsFirstPage(this.vaultUrl, roleScope, contextToUse), continuationToken -> this.listRoleDefinitionsNextPage((String)continuationToken, contextToUse));
    }

    PagedResponse<KeyVaultRoleDefinition> listRoleDefinitionsFirstPage(String vaultUrl, KeyVaultRoleScope roleScope, Context context) {
        Objects.requireNonNull(roleScope, String.format(KeyVaultErrorCodeStrings.getErrorString("parameter_required"), "'roleScope'"));
        try {
            PagedResponse<RoleDefinition> roleDefinitionPagedResponse = this.clientImpl.getRoleDefinitions().listSinglePage(vaultUrl, roleScope.toString(), null, context);
            return KeyVaultAdministrationUtil.transformRoleDefinitionsPagedResponse(roleDefinitionPagedResponse);
        }
        catch (KeyVaultErrorException e) {
            throw LOGGER.logExceptionAsError((RuntimeException)((Object)KeyVaultAdministrationUtils.toKeyVaultAdministrationException(e)));
        }
        catch (RuntimeException e) {
            throw LOGGER.logExceptionAsError(e);
        }
    }

    PagedResponse<KeyVaultRoleDefinition> listRoleDefinitionsNextPage(String continuationToken, Context context) {
        try {
            PagedResponse<RoleDefinition> roleDefinitionPagedResponse = this.clientImpl.getRoleDefinitions().listNextSinglePage(continuationToken, this.vaultUrl, context);
            return KeyVaultAdministrationUtil.transformRoleDefinitionsPagedResponse(roleDefinitionPagedResponse);
        }
        catch (KeyVaultErrorException e) {
            throw LOGGER.logExceptionAsError((RuntimeException)((Object)KeyVaultAdministrationUtils.toKeyVaultAdministrationException(e)));
        }
        catch (RuntimeException e) {
            throw LOGGER.logExceptionAsError(e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultRoleDefinition setRoleDefinition(KeyVaultRoleScope roleScope) {
        return this.setRoleDefinition(roleScope, UUID.randomUUID().toString());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultRoleDefinition setRoleDefinition(KeyVaultRoleScope roleScope, String roleDefinitionName) {
        return (KeyVaultRoleDefinition)this.setRoleDefinitionWithResponse(new SetRoleDefinitionOptions(roleScope, roleDefinitionName), Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultRoleDefinition> setRoleDefinitionWithResponse(SetRoleDefinitionOptions options, Context context) {
        context = KeyVaultAdministrationUtil.enableSyncRestProxy(context);
        RoleDefinitionCreateParameters parameters = KeyVaultAdministrationUtil.validateAndGetRoleDefinitionCreateParameters(options);
        try {
            Response<RoleDefinition> roleDefinitionResponse = this.clientImpl.getRoleDefinitions().createOrUpdateWithResponse(this.vaultUrl, options.getRoleScope().toString(), options.getRoleDefinitionName(), parameters, context);
            return KeyVaultAdministrationUtil.transformRoleDefinitionResponse(roleDefinitionResponse);
        }
        catch (KeyVaultErrorException e) {
            throw LOGGER.logExceptionAsError((RuntimeException)((Object)KeyVaultAdministrationUtils.toKeyVaultAdministrationException(e)));
        }
        catch (RuntimeException e) {
            throw LOGGER.logExceptionAsError(e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultRoleDefinition getRoleDefinition(KeyVaultRoleScope roleScope, String roleDefinitionName) {
        return (KeyVaultRoleDefinition)this.getRoleDefinitionWithResponse(roleScope, roleDefinitionName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultRoleDefinition> getRoleDefinitionWithResponse(KeyVaultRoleScope roleScope, String roleDefinitionName, Context context) {
        KeyVaultAdministrationUtil.validateRoleDefinitionParameters(roleScope, roleDefinitionName);
        try {
            context = KeyVaultAdministrationUtil.enableSyncRestProxy(context);
            Response<RoleDefinition> roleDefinitionResponse = this.clientImpl.getRoleDefinitions().getWithResponse(this.vaultUrl, roleScope.toString(), roleDefinitionName, context);
            return KeyVaultAdministrationUtil.transformRoleDefinitionResponse(roleDefinitionResponse);
        }
        catch (KeyVaultErrorException e) {
            throw LOGGER.logExceptionAsError((RuntimeException)((Object)KeyVaultAdministrationUtils.toKeyVaultAdministrationException(e)));
        }
        catch (RuntimeException e) {
            throw LOGGER.logExceptionAsError(e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteRoleDefinition(KeyVaultRoleScope roleScope, String roleDefinitionName) {
        this.deleteRoleDefinitionWithResponse(roleScope, roleDefinitionName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteRoleDefinitionWithResponse(KeyVaultRoleScope roleScope, String roleDefinitionName, Context context) {
        KeyVaultAdministrationUtil.validateRoleDefinitionParameters(roleScope, roleDefinitionName);
        try {
            context = KeyVaultAdministrationUtil.enableSyncRestProxy(context);
            Response<RoleDefinition> roleDefinitionResponse = this.clientImpl.getRoleDefinitions().deleteWithResponse(this.vaultUrl, roleScope.toString(), roleDefinitionName, context);
            return new SimpleResponse(roleDefinitionResponse, null);
        }
        catch (KeyVaultErrorException e) {
            KeyVaultAdministrationException mappedException = KeyVaultAdministrationUtils.toKeyVaultAdministrationException(e);
            return KeyVaultAdministrationUtil.swallowExceptionForStatusCodeSync(404, mappedException, LOGGER);
        }
        catch (RuntimeException e) {
            throw LOGGER.logExceptionAsError(e);
        }
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<KeyVaultRoleAssignment> listRoleAssignments(KeyVaultRoleScope roleScope) {
        return this.listRoleAssignments(roleScope, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<KeyVaultRoleAssignment> listRoleAssignments(KeyVaultRoleScope roleScope, Context context) {
        Context contextToUse = KeyVaultAdministrationUtil.enableSyncRestProxy(context);
        return new PagedIterable(() -> this.listRoleAssignmentsFirstPage(this.vaultUrl, roleScope, contextToUse), continuationToken -> this.listRoleAssignmentsNextPage((String)continuationToken, context));
    }

    PagedResponse<KeyVaultRoleAssignment> listRoleAssignmentsFirstPage(String vaultUrl, KeyVaultRoleScope roleScope, Context context) {
        Objects.requireNonNull(roleScope, String.format(KeyVaultErrorCodeStrings.getErrorString("parameter_required"), "'roleScope'"));
        try {
            PagedResponse<RoleAssignment> roleAssignmentPagedResponse = this.clientImpl.getRoleAssignments().listForScopeSinglePage(vaultUrl, roleScope.toString(), null, context);
            return KeyVaultAdministrationUtil.transformRoleAssignmentsPagedResponse(roleAssignmentPagedResponse);
        }
        catch (KeyVaultErrorException e) {
            throw LOGGER.logExceptionAsError((RuntimeException)((Object)KeyVaultAdministrationUtils.toKeyVaultAdministrationException(e)));
        }
        catch (RuntimeException e) {
            throw LOGGER.logExceptionAsError(e);
        }
    }

    PagedResponse<KeyVaultRoleAssignment> listRoleAssignmentsNextPage(String continuationToken, Context context) {
        try {
            PagedResponse<RoleAssignment> roleAssignmentPagedResponse = this.clientImpl.getRoleAssignments().listForScopeNextSinglePage(continuationToken, this.vaultUrl, context);
            return KeyVaultAdministrationUtil.transformRoleAssignmentsPagedResponse(roleAssignmentPagedResponse);
        }
        catch (KeyVaultErrorException e) {
            throw LOGGER.logExceptionAsError((RuntimeException)((Object)KeyVaultAdministrationUtils.toKeyVaultAdministrationException(e)));
        }
        catch (RuntimeException e) {
            throw LOGGER.logExceptionAsError(e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultRoleAssignment createRoleAssignment(KeyVaultRoleScope roleScope, String roleDefinitionId, String principalId) {
        return (KeyVaultRoleAssignment)this.createRoleAssignmentWithResponse(roleScope, roleDefinitionId, principalId, UUID.randomUUID().toString(), Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultRoleAssignment createRoleAssignment(KeyVaultRoleScope roleScope, String roleDefinitionId, String principalId, String roleAssignmentName) {
        return (KeyVaultRoleAssignment)this.createRoleAssignmentWithResponse(roleScope, roleDefinitionId, principalId, roleAssignmentName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultRoleAssignment> createRoleAssignmentWithResponse(KeyVaultRoleScope roleScope, String roleDefinitionId, String principalId, String roleAssignmentName, Context context) {
        RoleAssignmentCreateParameters parameters = KeyVaultAdministrationUtil.validateAndGetRoleAssignmentCreateParameters(roleScope, roleDefinitionId, principalId, roleAssignmentName);
        context = KeyVaultAdministrationUtil.enableSyncRestProxy(context);
        try {
            Response<RoleAssignment> roleAssignmentResponse = this.clientImpl.getRoleAssignments().createWithResponse(this.vaultUrl, roleScope.toString(), roleAssignmentName, parameters, context);
            return KeyVaultAdministrationUtil.transformRoleAssignmentResponse(roleAssignmentResponse);
        }
        catch (KeyVaultErrorException e) {
            throw LOGGER.logExceptionAsError((RuntimeException)((Object)KeyVaultAdministrationUtils.toKeyVaultAdministrationException(e)));
        }
        catch (RuntimeException e) {
            throw LOGGER.logExceptionAsError(e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultRoleAssignment getRoleAssignment(KeyVaultRoleScope roleScope, String roleAssignmentName) {
        return (KeyVaultRoleAssignment)this.getRoleAssignmentWithResponse(roleScope, roleAssignmentName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultRoleAssignment> getRoleAssignmentWithResponse(KeyVaultRoleScope roleScope, String roleAssignmentName, Context context) {
        KeyVaultAdministrationUtil.validateRoleAssignmentParameters(roleScope, roleAssignmentName);
        try {
            context = KeyVaultAdministrationUtil.enableSyncRestProxy(context);
            Response<RoleAssignment> roleAssignmentResponse = this.clientImpl.getRoleAssignments().getWithResponse(this.vaultUrl, roleScope.toString(), roleAssignmentName, context);
            return KeyVaultAdministrationUtil.transformRoleAssignmentResponse(roleAssignmentResponse);
        }
        catch (KeyVaultErrorException e) {
            throw LOGGER.logExceptionAsError((RuntimeException)((Object)KeyVaultAdministrationUtils.toKeyVaultAdministrationException(e)));
        }
        catch (RuntimeException e) {
            throw LOGGER.logExceptionAsError(e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteRoleAssignment(KeyVaultRoleScope roleScope, String roleAssignmentName) {
        this.deleteRoleAssignmentWithResponse(roleScope, roleAssignmentName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteRoleAssignmentWithResponse(KeyVaultRoleScope roleScope, String roleAssignmentName, Context context) {
        KeyVaultAdministrationUtil.validateRoleAssignmentParameters(roleScope, roleAssignmentName);
        try {
            context = KeyVaultAdministrationUtil.enableSyncRestProxy(context);
            Response<RoleAssignment> roleAssignmentResponse = this.clientImpl.getRoleAssignments().deleteWithResponse(this.vaultUrl, roleScope.toString(), roleAssignmentName, context);
            return new SimpleResponse(roleAssignmentResponse, null);
        }
        catch (KeyVaultErrorException e) {
            KeyVaultAdministrationException mappedException = KeyVaultAdministrationUtils.toKeyVaultAdministrationException(e);
            return KeyVaultAdministrationUtil.swallowExceptionForStatusCodeSync(404, mappedException, LOGGER);
        }
        catch (RuntimeException e) {
            throw LOGGER.logExceptionAsError(e);
        }
    }
}

