// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.security.keyvault.administration.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The Setting model. */
@Fluent
public final class Setting {
    /*
     * The account setting to be updated
     */
    @JsonProperty(value = "name", required = true)
    private String name;

    /*
     * The value of the pool setting.
     */
    @JsonProperty(value = "value", required = true)
    private String value;

    /*
     * The type specifier of the value.
     */
    @JsonProperty(value = "type")
    private SettingTypeEnum type;

    /** Creates an instance of Setting class. */
    public Setting() {}

    /**
     * Get the name property: The account setting to be updated.
     *
     * @return the name value.
     */
    public String getName() {
        return this.name;
    }

    /**
     * Set the name property: The account setting to be updated.
     *
     * @param name the name value to set.
     * @return the Setting object itself.
     */
    public Setting setName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the value property: The value of the pool setting.
     *
     * @return the value value.
     */
    public String getValue() {
        return this.value;
    }

    /**
     * Set the value property: The value of the pool setting.
     *
     * @param value the value value to set.
     * @return the Setting object itself.
     */
    public Setting setValue(String value) {
        this.value = value;
        return this;
    }

    /**
     * Get the type property: The type specifier of the value.
     *
     * @return the type value.
     */
    public SettingTypeEnum getType() {
        return this.type;
    }

    /**
     * Set the type property: The type specifier of the value.
     *
     * @param type the type value to set.
     * @return the Setting object itself.
     */
    public Setting setType(SettingTypeEnum type) {
        this.type = type;
        return this;
    }
}
