// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.security.keyvault.administration.implementation.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** The role definition type. */
public final class RoleDefinitionType extends ExpandableStringEnum<RoleDefinitionType> {
    /** Static value Microsoft.Authorization/roleDefinitions for RoleDefinitionType. */
    public static final RoleDefinitionType MICROSOFT_AUTHORIZATION_ROLE_DEFINITIONS =
            fromString("Microsoft.Authorization/roleDefinitions");

    /**
     * Creates a new instance of RoleDefinitionType value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public RoleDefinitionType() {}

    /**
     * Creates or finds a RoleDefinitionType from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding RoleDefinitionType.
     */
    @JsonCreator
    public static RoleDefinitionType fromString(String name) {
        return fromString(name, RoleDefinitionType.class);
    }

    /**
     * Gets known RoleDefinitionType values.
     *
     * @return known RoleDefinitionType values.
     */
    public static Collection<RoleDefinitionType> values() {
        return values(RoleDefinitionType.class);
    }
}
