// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.security.keyvault.administration.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Restore operation. */
@Fluent
public final class RestoreOperation {
    /*
     * Status of the restore operation.
     */
    @JsonProperty(value = "status")
    private String status;

    /*
     * The status details of restore operation.
     */
    @JsonProperty(value = "statusDetails")
    private String statusDetails;

    /*
     * Error encountered, if any, during the restore operation.
     */
    @JsonProperty(value = "error")
    private Error error;

    /*
     * Identifier for the restore operation.
     */
    @JsonProperty(value = "jobId")
    private String jobId;

    /*
     * The start time of the restore operation
     */
    @JsonProperty(value = "startTime")
    private Long startTime;

    /*
     * The end time of the restore operation
     */
    @JsonProperty(value = "endTime")
    private Long endTime;

    /** Creates an instance of RestoreOperation class. */
    public RestoreOperation() {}

    /**
     * Get the status property: Status of the restore operation.
     *
     * @return the status value.
     */
    public String getStatus() {
        return this.status;
    }

    /**
     * Set the status property: Status of the restore operation.
     *
     * @param status the status value to set.
     * @return the RestoreOperation object itself.
     */
    public RestoreOperation setStatus(String status) {
        this.status = status;
        return this;
    }

    /**
     * Get the statusDetails property: The status details of restore operation.
     *
     * @return the statusDetails value.
     */
    public String getStatusDetails() {
        return this.statusDetails;
    }

    /**
     * Set the statusDetails property: The status details of restore operation.
     *
     * @param statusDetails the statusDetails value to set.
     * @return the RestoreOperation object itself.
     */
    public RestoreOperation setStatusDetails(String statusDetails) {
        this.statusDetails = statusDetails;
        return this;
    }

    /**
     * Get the error property: Error encountered, if any, during the restore operation.
     *
     * @return the error value.
     */
    public Error getError() {
        return this.error;
    }

    /**
     * Set the error property: Error encountered, if any, during the restore operation.
     *
     * @param error the error value to set.
     * @return the RestoreOperation object itself.
     */
    public RestoreOperation setError(Error error) {
        this.error = error;
        return this;
    }

    /**
     * Get the jobId property: Identifier for the restore operation.
     *
     * @return the jobId value.
     */
    public String getJobId() {
        return this.jobId;
    }

    /**
     * Set the jobId property: Identifier for the restore operation.
     *
     * @param jobId the jobId value to set.
     * @return the RestoreOperation object itself.
     */
    public RestoreOperation setJobId(String jobId) {
        this.jobId = jobId;
        return this;
    }

    /**
     * Get the startTime property: The start time of the restore operation.
     *
     * @return the startTime value.
     */
    public Long getStartTime() {
        return this.startTime;
    }

    /**
     * Set the startTime property: The start time of the restore operation.
     *
     * @param startTime the startTime value to set.
     * @return the RestoreOperation object itself.
     */
    public RestoreOperation setStartTime(Long startTime) {
        this.startTime = startTime;
        return this;
    }

    /**
     * Get the endTime property: The end time of the restore operation.
     *
     * @return the endTime value.
     */
    public Long getEndTime() {
        return this.endTime;
    }

    /**
     * Set the endTime property: The end time of the restore operation.
     *
     * @param endTime the endTime value to set.
     * @return the RestoreOperation object itself.
     */
    public RestoreOperation setEndTime(Long endTime) {
        this.endTime = endTime;
        return this;
    }
}
