// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.security.keyvault.administration.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Role definition permissions. */
@Fluent
public final class Permission {
    /*
     * Action permissions that are granted.
     */
    @JsonProperty(value = "actions")
    private List<String> actions;

    /*
     * Action permissions that are excluded but not denied. They may be granted by other role definitions assigned to a
     * principal.
     */
    @JsonProperty(value = "notActions")
    private List<String> notActions;

    /*
     * Data action permissions that are granted.
     */
    @JsonProperty(value = "dataActions")
    private List<DataAction> dataActions;

    /*
     * Data action permissions that are excluded but not denied. They may be granted by other role definitions assigned
     * to a principal.
     */
    @JsonProperty(value = "notDataActions")
    private List<DataAction> notDataActions;

    /** Creates an instance of Permission class. */
    public Permission() {}

    /**
     * Get the actions property: Action permissions that are granted.
     *
     * @return the actions value.
     */
    public List<String> getActions() {
        return this.actions;
    }

    /**
     * Set the actions property: Action permissions that are granted.
     *
     * @param actions the actions value to set.
     * @return the Permission object itself.
     */
    public Permission setActions(List<String> actions) {
        this.actions = actions;
        return this;
    }

    /**
     * Get the notActions property: Action permissions that are excluded but not denied. They may be granted by other
     * role definitions assigned to a principal.
     *
     * @return the notActions value.
     */
    public List<String> getNotActions() {
        return this.notActions;
    }

    /**
     * Set the notActions property: Action permissions that are excluded but not denied. They may be granted by other
     * role definitions assigned to a principal.
     *
     * @param notActions the notActions value to set.
     * @return the Permission object itself.
     */
    public Permission setNotActions(List<String> notActions) {
        this.notActions = notActions;
        return this;
    }

    /**
     * Get the dataActions property: Data action permissions that are granted.
     *
     * @return the dataActions value.
     */
    public List<DataAction> getDataActions() {
        return this.dataActions;
    }

    /**
     * Set the dataActions property: Data action permissions that are granted.
     *
     * @param dataActions the dataActions value to set.
     * @return the Permission object itself.
     */
    public Permission setDataActions(List<DataAction> dataActions) {
        this.dataActions = dataActions;
        return this;
    }

    /**
     * Get the notDataActions property: Data action permissions that are excluded but not denied. They may be granted by
     * other role definitions assigned to a principal.
     *
     * @return the notDataActions value.
     */
    public List<DataAction> getNotDataActions() {
        return this.notDataActions;
    }

    /**
     * Set the notDataActions property: Data action permissions that are excluded but not denied. They may be granted by
     * other role definitions assigned to a principal.
     *
     * @param notDataActions the notDataActions value to set.
     * @return the Permission object itself.
     */
    public Permission setNotDataActions(List<DataAction> notDataActions) {
        this.notDataActions = notDataActions;
        return this;
    }
}
