// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.security.keyvault.administration.implementation.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Supported permissions for data actions. */
public final class DataAction extends ExpandableStringEnum<DataAction> {
    /** Static value Microsoft.KeyVault/managedHsm/keys/read/action for DataAction. */
    public static final DataAction READ_HSM_KEY = fromString("Microsoft.KeyVault/managedHsm/keys/read/action");

    /** Static value Microsoft.KeyVault/managedHsm/keys/write/action for DataAction. */
    public static final DataAction WRITE_HSM_KEY = fromString("Microsoft.KeyVault/managedHsm/keys/write/action");

    /** Static value Microsoft.KeyVault/managedHsm/keys/deletedKeys/read/action for DataAction. */
    public static final DataAction READ_DELETED_HSM_KEY =
            fromString("Microsoft.KeyVault/managedHsm/keys/deletedKeys/read/action");

    /** Static value Microsoft.KeyVault/managedHsm/keys/deletedKeys/recover/action for DataAction. */
    public static final DataAction RECOVER_DELETED_HSM_KEY =
            fromString("Microsoft.KeyVault/managedHsm/keys/deletedKeys/recover/action");

    /** Static value Microsoft.KeyVault/managedHsm/keys/backup/action for DataAction. */
    public static final DataAction BACKUP_HSM_KEYS = fromString("Microsoft.KeyVault/managedHsm/keys/backup/action");

    /** Static value Microsoft.KeyVault/managedHsm/keys/restore/action for DataAction. */
    public static final DataAction RESTORE_HSM_KEYS = fromString("Microsoft.KeyVault/managedHsm/keys/restore/action");

    /** Static value Microsoft.KeyVault/managedHsm/roleAssignments/delete/action for DataAction. */
    public static final DataAction DELETE_ROLE_ASSIGNMENT =
            fromString("Microsoft.KeyVault/managedHsm/roleAssignments/delete/action");

    /** Static value Microsoft.KeyVault/managedHsm/roleAssignments/read/action for DataAction. */
    public static final DataAction GET_ROLE_ASSIGNMENT =
            fromString("Microsoft.KeyVault/managedHsm/roleAssignments/read/action");

    /** Static value Microsoft.KeyVault/managedHsm/roleAssignments/write/action for DataAction. */
    public static final DataAction WRITE_ROLE_ASSIGNMENT =
            fromString("Microsoft.KeyVault/managedHsm/roleAssignments/write/action");

    /** Static value Microsoft.KeyVault/managedHsm/roleDefinitions/read/action for DataAction. */
    public static final DataAction READ_ROLE_DEFINITION =
            fromString("Microsoft.KeyVault/managedHsm/roleDefinitions/read/action");

    /** Static value Microsoft.KeyVault/managedHsm/roleDefinitions/write/action for DataAction. */
    public static final DataAction WRITE_ROLE_DEFINITION =
            fromString("Microsoft.KeyVault/managedHsm/roleDefinitions/write/action");

    /** Static value Microsoft.KeyVault/managedHsm/roleDefinitions/delete/action for DataAction. */
    public static final DataAction DELETE_ROLE_DEFINITION =
            fromString("Microsoft.KeyVault/managedHsm/roleDefinitions/delete/action");

    /** Static value Microsoft.KeyVault/managedHsm/keys/encrypt/action for DataAction. */
    public static final DataAction ENCRYPT_HSM_KEY = fromString("Microsoft.KeyVault/managedHsm/keys/encrypt/action");

    /** Static value Microsoft.KeyVault/managedHsm/keys/decrypt/action for DataAction. */
    public static final DataAction DECRYPT_HSM_KEY = fromString("Microsoft.KeyVault/managedHsm/keys/decrypt/action");

    /** Static value Microsoft.KeyVault/managedHsm/keys/wrap/action for DataAction. */
    public static final DataAction WRAP_HSM_KEY = fromString("Microsoft.KeyVault/managedHsm/keys/wrap/action");

    /** Static value Microsoft.KeyVault/managedHsm/keys/unwrap/action for DataAction. */
    public static final DataAction UNWRAP_HSM_KEY = fromString("Microsoft.KeyVault/managedHsm/keys/unwrap/action");

    /** Static value Microsoft.KeyVault/managedHsm/keys/sign/action for DataAction. */
    public static final DataAction SIGN_HSM_KEY = fromString("Microsoft.KeyVault/managedHsm/keys/sign/action");

    /** Static value Microsoft.KeyVault/managedHsm/keys/verify/action for DataAction. */
    public static final DataAction VERIFY_HSM_KEY = fromString("Microsoft.KeyVault/managedHsm/keys/verify/action");

    /** Static value Microsoft.KeyVault/managedHsm/keys/create for DataAction. */
    public static final DataAction CREATE_HSM_KEY = fromString("Microsoft.KeyVault/managedHsm/keys/create");

    /** Static value Microsoft.KeyVault/managedHsm/keys/delete for DataAction. */
    public static final DataAction DELETE_HSM_KEY = fromString("Microsoft.KeyVault/managedHsm/keys/delete");

    /** Static value Microsoft.KeyVault/managedHsm/keys/export/action for DataAction. */
    public static final DataAction EXPORT_HSM_KEY = fromString("Microsoft.KeyVault/managedHsm/keys/export/action");

    /** Static value Microsoft.KeyVault/managedHsm/keys/release/action for DataAction. */
    public static final DataAction RELEASE_KEY = fromString("Microsoft.KeyVault/managedHsm/keys/release/action");

    /** Static value Microsoft.KeyVault/managedHsm/keys/import/action for DataAction. */
    public static final DataAction IMPORT_HSM_KEY = fromString("Microsoft.KeyVault/managedHsm/keys/import/action");

    /** Static value Microsoft.KeyVault/managedHsm/keys/deletedKeys/delete for DataAction. */
    public static final DataAction PURGE_DELETED_HSM_KEY =
            fromString("Microsoft.KeyVault/managedHsm/keys/deletedKeys/delete");

    /** Static value Microsoft.KeyVault/managedHsm/securitydomain/download/action for DataAction. */
    public static final DataAction DOWNLOAD_HSM_SECURITY_DOMAIN =
            fromString("Microsoft.KeyVault/managedHsm/securitydomain/download/action");

    /** Static value Microsoft.KeyVault/managedHsm/securitydomain/download/read for DataAction. */
    public static final DataAction DOWNLOAD_HSM_SECURITY_DOMAIN_STATUS =
            fromString("Microsoft.KeyVault/managedHsm/securitydomain/download/read");

    /** Static value Microsoft.KeyVault/managedHsm/securitydomain/upload/action for DataAction. */
    public static final DataAction UPLOAD_HSM_SECURITY_DOMAIN =
            fromString("Microsoft.KeyVault/managedHsm/securitydomain/upload/action");

    /** Static value Microsoft.KeyVault/managedHsm/securitydomain/upload/read for DataAction. */
    public static final DataAction READ_HSM_SECURITY_DOMAIN_STATUS =
            fromString("Microsoft.KeyVault/managedHsm/securitydomain/upload/read");

    /** Static value Microsoft.KeyVault/managedHsm/securitydomain/transferkey/read for DataAction. */
    public static final DataAction READ_HSM_SECURITY_DOMAIN_TRANSFER_KEY =
            fromString("Microsoft.KeyVault/managedHsm/securitydomain/transferkey/read");

    /** Static value Microsoft.KeyVault/managedHsm/backup/start/action for DataAction. */
    public static final DataAction START_HSM_BACKUP = fromString("Microsoft.KeyVault/managedHsm/backup/start/action");

    /** Static value Microsoft.KeyVault/managedHsm/restore/start/action for DataAction. */
    public static final DataAction START_HSM_RESTORE = fromString("Microsoft.KeyVault/managedHsm/restore/start/action");

    /** Static value Microsoft.KeyVault/managedHsm/backup/status/action for DataAction. */
    public static final DataAction READ_HSM_BACKUP_STATUS =
            fromString("Microsoft.KeyVault/managedHsm/backup/status/action");

    /** Static value Microsoft.KeyVault/managedHsm/restore/status/action for DataAction. */
    public static final DataAction READ_HSM_RESTORE_STATUS =
            fromString("Microsoft.KeyVault/managedHsm/restore/status/action");

    /** Static value Microsoft.KeyVault/managedHsm/rng/action for DataAction. */
    public static final DataAction RANDOM_NUMBERS_GENERATE = fromString("Microsoft.KeyVault/managedHsm/rng/action");

    /**
     * Creates a new instance of DataAction value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public DataAction() {}

    /**
     * Creates or finds a DataAction from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding DataAction.
     */
    @JsonCreator
    public static DataAction fromString(String name) {
        return fromString(name, DataAction.class);
    }

    /**
     * Gets known DataAction values.
     *
     * @return known DataAction values.
     */
    public static Collection<DataAction> values() {
        return values(DataAction.class);
    }
}
