// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.security.keyvault.administration.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.security.keyvault.administration.implementation.models.KeyVaultErrorException;
import com.azure.security.keyvault.administration.implementation.models.RoleAssignment;
import com.azure.security.keyvault.administration.implementation.models.RoleAssignmentCreateParameters;
import com.azure.security.keyvault.administration.implementation.models.RoleAssignmentListResult;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in RoleAssignments. */
public final class RoleAssignmentsImpl {
    /** The proxy service used to perform REST calls. */
    private final RoleAssignmentsService service;

    /** The service client containing this operation class. */
    private final KeyVaultAccessControlClientImpl client;

    /**
     * Initializes an instance of RoleAssignmentsImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    RoleAssignmentsImpl(KeyVaultAccessControlClientImpl client) {
        this.service =
                RestProxy.create(RoleAssignmentsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for KeyVaultAccessControlClientRoleAssignments to be used by the proxy
     * service to perform REST calls.
     */
    @Host("{vaultBaseUrl}")
    @ServiceInterface(name = "KeyVaultAccessContro")
    public interface RoleAssignmentsService {
        @Delete("/{scope}/providers/Microsoft.Authorization/roleAssignments/{roleAssignmentName}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Mono<Response<RoleAssignment>> delete(
                @HostParam("vaultBaseUrl") String vaultBaseUrl,
                @PathParam(value = "scope", encoded = true) String scope,
                @PathParam("roleAssignmentName") String roleAssignmentName,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);

        @Delete("/{scope}/providers/Microsoft.Authorization/roleAssignments/{roleAssignmentName}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Response<RoleAssignment> deleteSync(
                @HostParam("vaultBaseUrl") String vaultBaseUrl,
                @PathParam(value = "scope", encoded = true) String scope,
                @PathParam("roleAssignmentName") String roleAssignmentName,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);

        @Put("/{scope}/providers/Microsoft.Authorization/roleAssignments/{roleAssignmentName}")
        @ExpectedResponses({201})
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Mono<Response<RoleAssignment>> create(
                @HostParam("vaultBaseUrl") String vaultBaseUrl,
                @PathParam(value = "scope", encoded = true) String scope,
                @PathParam("roleAssignmentName") String roleAssignmentName,
                @QueryParam("api-version") String apiVersion,
                @BodyParam("application/json") RoleAssignmentCreateParameters parameters,
                @HeaderParam("Accept") String accept,
                Context context);

        @Put("/{scope}/providers/Microsoft.Authorization/roleAssignments/{roleAssignmentName}")
        @ExpectedResponses({201})
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Response<RoleAssignment> createSync(
                @HostParam("vaultBaseUrl") String vaultBaseUrl,
                @PathParam(value = "scope", encoded = true) String scope,
                @PathParam("roleAssignmentName") String roleAssignmentName,
                @QueryParam("api-version") String apiVersion,
                @BodyParam("application/json") RoleAssignmentCreateParameters parameters,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/{scope}/providers/Microsoft.Authorization/roleAssignments/{roleAssignmentName}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Mono<Response<RoleAssignment>> get(
                @HostParam("vaultBaseUrl") String vaultBaseUrl,
                @PathParam(value = "scope", encoded = true) String scope,
                @PathParam("roleAssignmentName") String roleAssignmentName,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/{scope}/providers/Microsoft.Authorization/roleAssignments/{roleAssignmentName}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Response<RoleAssignment> getSync(
                @HostParam("vaultBaseUrl") String vaultBaseUrl,
                @PathParam(value = "scope", encoded = true) String scope,
                @PathParam("roleAssignmentName") String roleAssignmentName,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/{scope}/providers/Microsoft.Authorization/roleAssignments")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Mono<Response<RoleAssignmentListResult>> listForScope(
                @HostParam("vaultBaseUrl") String vaultBaseUrl,
                @PathParam(value = "scope", encoded = true) String scope,
                @QueryParam("$filter") String filter,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/{scope}/providers/Microsoft.Authorization/roleAssignments")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Response<RoleAssignmentListResult> listForScopeSync(
                @HostParam("vaultBaseUrl") String vaultBaseUrl,
                @PathParam(value = "scope", encoded = true) String scope,
                @QueryParam("$filter") String filter,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Mono<Response<RoleAssignmentListResult>> listForScopeNext(
                @PathParam(value = "nextLink", encoded = true) String nextLink,
                @HostParam("vaultBaseUrl") String vaultBaseUrl,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Response<RoleAssignmentListResult> listForScopeNextSync(
                @PathParam(value = "nextLink", encoded = true) String nextLink,
                @HostParam("vaultBaseUrl") String vaultBaseUrl,
                @HeaderParam("Accept") String accept,
                Context context);
    }

    /**
     * Deletes a role assignment.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param scope The scope of the role assignment to delete.
     * @param roleAssignmentName The name of the role assignment to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role Assignments along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<RoleAssignment>> deleteWithResponseAsync(
            String vaultBaseUrl, String scope, String roleAssignmentName) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.delete(
                                vaultBaseUrl, scope, roleAssignmentName, this.client.getApiVersion(), accept, context));
    }

    /**
     * Deletes a role assignment.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param scope The scope of the role assignment to delete.
     * @param roleAssignmentName The name of the role assignment to delete.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role Assignments along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<RoleAssignment>> deleteWithResponseAsync(
            String vaultBaseUrl, String scope, String roleAssignmentName, Context context) {
        final String accept = "application/json";
        return service.delete(vaultBaseUrl, scope, roleAssignmentName, this.client.getApiVersion(), accept, context);
    }

    /**
     * Deletes a role assignment.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param scope The scope of the role assignment to delete.
     * @param roleAssignmentName The name of the role assignment to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role Assignments on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<RoleAssignment> deleteAsync(String vaultBaseUrl, String scope, String roleAssignmentName) {
        return deleteWithResponseAsync(vaultBaseUrl, scope, roleAssignmentName)
                .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Deletes a role assignment.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param scope The scope of the role assignment to delete.
     * @param roleAssignmentName The name of the role assignment to delete.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role Assignments on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<RoleAssignment> deleteAsync(
            String vaultBaseUrl, String scope, String roleAssignmentName, Context context) {
        return deleteWithResponseAsync(vaultBaseUrl, scope, roleAssignmentName, context)
                .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Deletes a role assignment.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param scope The scope of the role assignment to delete.
     * @param roleAssignmentName The name of the role assignment to delete.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role Assignments along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<RoleAssignment> deleteWithResponse(
            String vaultBaseUrl, String scope, String roleAssignmentName, Context context) {
        final String accept = "application/json";
        return service.deleteSync(
                vaultBaseUrl, scope, roleAssignmentName, this.client.getApiVersion(), accept, context);
    }

    /**
     * Deletes a role assignment.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param scope The scope of the role assignment to delete.
     * @param roleAssignmentName The name of the role assignment to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role Assignments.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public RoleAssignment delete(String vaultBaseUrl, String scope, String roleAssignmentName) {
        return deleteWithResponse(vaultBaseUrl, scope, roleAssignmentName, Context.NONE).getValue();
    }

    /**
     * Creates a role assignment.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param scope The scope of the role assignment to create.
     * @param roleAssignmentName The name of the role assignment to create. It can be any valid GUID.
     * @param parameters Parameters for the role assignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role Assignments along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<RoleAssignment>> createWithResponseAsync(
            String vaultBaseUrl, String scope, String roleAssignmentName, RoleAssignmentCreateParameters parameters) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.create(
                                vaultBaseUrl,
                                scope,
                                roleAssignmentName,
                                this.client.getApiVersion(),
                                parameters,
                                accept,
                                context));
    }

    /**
     * Creates a role assignment.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param scope The scope of the role assignment to create.
     * @param roleAssignmentName The name of the role assignment to create. It can be any valid GUID.
     * @param parameters Parameters for the role assignment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role Assignments along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<RoleAssignment>> createWithResponseAsync(
            String vaultBaseUrl,
            String scope,
            String roleAssignmentName,
            RoleAssignmentCreateParameters parameters,
            Context context) {
        final String accept = "application/json";
        return service.create(
                vaultBaseUrl, scope, roleAssignmentName, this.client.getApiVersion(), parameters, accept, context);
    }

    /**
     * Creates a role assignment.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param scope The scope of the role assignment to create.
     * @param roleAssignmentName The name of the role assignment to create. It can be any valid GUID.
     * @param parameters Parameters for the role assignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role Assignments on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<RoleAssignment> createAsync(
            String vaultBaseUrl, String scope, String roleAssignmentName, RoleAssignmentCreateParameters parameters) {
        return createWithResponseAsync(vaultBaseUrl, scope, roleAssignmentName, parameters)
                .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Creates a role assignment.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param scope The scope of the role assignment to create.
     * @param roleAssignmentName The name of the role assignment to create. It can be any valid GUID.
     * @param parameters Parameters for the role assignment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role Assignments on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<RoleAssignment> createAsync(
            String vaultBaseUrl,
            String scope,
            String roleAssignmentName,
            RoleAssignmentCreateParameters parameters,
            Context context) {
        return createWithResponseAsync(vaultBaseUrl, scope, roleAssignmentName, parameters, context)
                .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Creates a role assignment.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param scope The scope of the role assignment to create.
     * @param roleAssignmentName The name of the role assignment to create. It can be any valid GUID.
     * @param parameters Parameters for the role assignment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role Assignments along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<RoleAssignment> createWithResponse(
            String vaultBaseUrl,
            String scope,
            String roleAssignmentName,
            RoleAssignmentCreateParameters parameters,
            Context context) {
        final String accept = "application/json";
        return service.createSync(
                vaultBaseUrl, scope, roleAssignmentName, this.client.getApiVersion(), parameters, accept, context);
    }

    /**
     * Creates a role assignment.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param scope The scope of the role assignment to create.
     * @param roleAssignmentName The name of the role assignment to create. It can be any valid GUID.
     * @param parameters Parameters for the role assignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role Assignments.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public RoleAssignment create(
            String vaultBaseUrl, String scope, String roleAssignmentName, RoleAssignmentCreateParameters parameters) {
        return createWithResponse(vaultBaseUrl, scope, roleAssignmentName, parameters, Context.NONE).getValue();
    }

    /**
     * Get the specified role assignment.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param scope The scope of the role assignment.
     * @param roleAssignmentName The name of the role assignment to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified role assignment along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<RoleAssignment>> getWithResponseAsync(
            String vaultBaseUrl, String scope, String roleAssignmentName) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.get(
                                vaultBaseUrl, scope, roleAssignmentName, this.client.getApiVersion(), accept, context));
    }

    /**
     * Get the specified role assignment.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param scope The scope of the role assignment.
     * @param roleAssignmentName The name of the role assignment to get.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified role assignment along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<RoleAssignment>> getWithResponseAsync(
            String vaultBaseUrl, String scope, String roleAssignmentName, Context context) {
        final String accept = "application/json";
        return service.get(vaultBaseUrl, scope, roleAssignmentName, this.client.getApiVersion(), accept, context);
    }

    /**
     * Get the specified role assignment.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param scope The scope of the role assignment.
     * @param roleAssignmentName The name of the role assignment to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified role assignment on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<RoleAssignment> getAsync(String vaultBaseUrl, String scope, String roleAssignmentName) {
        return getWithResponseAsync(vaultBaseUrl, scope, roleAssignmentName)
                .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Get the specified role assignment.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param scope The scope of the role assignment.
     * @param roleAssignmentName The name of the role assignment to get.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified role assignment on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<RoleAssignment> getAsync(
            String vaultBaseUrl, String scope, String roleAssignmentName, Context context) {
        return getWithResponseAsync(vaultBaseUrl, scope, roleAssignmentName, context)
                .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Get the specified role assignment.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param scope The scope of the role assignment.
     * @param roleAssignmentName The name of the role assignment to get.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified role assignment along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<RoleAssignment> getWithResponse(
            String vaultBaseUrl, String scope, String roleAssignmentName, Context context) {
        final String accept = "application/json";
        return service.getSync(vaultBaseUrl, scope, roleAssignmentName, this.client.getApiVersion(), accept, context);
    }

    /**
     * Get the specified role assignment.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param scope The scope of the role assignment.
     * @param roleAssignmentName The name of the role assignment to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified role assignment.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public RoleAssignment get(String vaultBaseUrl, String scope, String roleAssignmentName) {
        return getWithResponse(vaultBaseUrl, scope, roleAssignmentName, Context.NONE).getValue();
    }

    /**
     * Gets role assignments for a scope.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param scope The scope of the role assignments.
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all role assignments at or
     *     above the scope. Use $filter=principalId eq {id} to return all role assignments at, above or below the scope
     *     for the specified principal.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role assignments for a scope along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<RoleAssignment>> listForScopeSinglePageAsync(
            String vaultBaseUrl, String scope, String filter) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                        context ->
                                service.listForScope(
                                        vaultBaseUrl, scope, filter, this.client.getApiVersion(), accept, context))
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * Gets role assignments for a scope.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param scope The scope of the role assignments.
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all role assignments at or
     *     above the scope. Use $filter=principalId eq {id} to return all role assignments at, above or below the scope
     *     for the specified principal.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role assignments for a scope along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<RoleAssignment>> listForScopeSinglePageAsync(
            String vaultBaseUrl, String scope, String filter, Context context) {
        final String accept = "application/json";
        return service.listForScope(vaultBaseUrl, scope, filter, this.client.getApiVersion(), accept, context)
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * Gets role assignments for a scope.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param scope The scope of the role assignments.
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all role assignments at or
     *     above the scope. Use $filter=principalId eq {id} to return all role assignments at, above or below the scope
     *     for the specified principal.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role assignments for a scope as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<RoleAssignment> listForScopeAsync(String vaultBaseUrl, String scope, String filter) {
        return new PagedFlux<>(
                () -> listForScopeSinglePageAsync(vaultBaseUrl, scope, filter),
                nextLink -> listForScopeNextSinglePageAsync(nextLink, vaultBaseUrl));
    }

    /**
     * Gets role assignments for a scope.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param scope The scope of the role assignments.
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all role assignments at or
     *     above the scope. Use $filter=principalId eq {id} to return all role assignments at, above or below the scope
     *     for the specified principal.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role assignments for a scope as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<RoleAssignment> listForScopeAsync(
            String vaultBaseUrl, String scope, String filter, Context context) {
        return new PagedFlux<>(
                () -> listForScopeSinglePageAsync(vaultBaseUrl, scope, filter, context),
                nextLink -> listForScopeNextSinglePageAsync(nextLink, vaultBaseUrl, context));
    }

    /**
     * Gets role assignments for a scope.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param scope The scope of the role assignments.
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all role assignments at or
     *     above the scope. Use $filter=principalId eq {id} to return all role assignments at, above or below the scope
     *     for the specified principal.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role assignments for a scope along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<RoleAssignment> listForScopeSinglePage(String vaultBaseUrl, String scope, String filter) {
        final String accept = "application/json";
        Response<RoleAssignmentListResult> res =
                service.listForScopeSync(
                        vaultBaseUrl, scope, filter, this.client.getApiVersion(), accept, Context.NONE);
        return new PagedResponseBase<>(
                res.getRequest(),
                res.getStatusCode(),
                res.getHeaders(),
                res.getValue().getValue(),
                res.getValue().getNextLink(),
                null);
    }

    /**
     * Gets role assignments for a scope.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param scope The scope of the role assignments.
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all role assignments at or
     *     above the scope. Use $filter=principalId eq {id} to return all role assignments at, above or below the scope
     *     for the specified principal.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role assignments for a scope along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<RoleAssignment> listForScopeSinglePage(
            String vaultBaseUrl, String scope, String filter, Context context) {
        final String accept = "application/json";
        Response<RoleAssignmentListResult> res =
                service.listForScopeSync(vaultBaseUrl, scope, filter, this.client.getApiVersion(), accept, context);
        return new PagedResponseBase<>(
                res.getRequest(),
                res.getStatusCode(),
                res.getHeaders(),
                res.getValue().getValue(),
                res.getValue().getNextLink(),
                null);
    }

    /**
     * Gets role assignments for a scope.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param scope The scope of the role assignments.
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all role assignments at or
     *     above the scope. Use $filter=principalId eq {id} to return all role assignments at, above or below the scope
     *     for the specified principal.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role assignments for a scope as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<RoleAssignment> listForScope(String vaultBaseUrl, String scope, String filter) {
        return new PagedIterable<>(
                () -> listForScopeSinglePage(vaultBaseUrl, scope, filter, Context.NONE),
                nextLink -> listForScopeNextSinglePage(nextLink, vaultBaseUrl));
    }

    /**
     * Gets role assignments for a scope.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param scope The scope of the role assignments.
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all role assignments at or
     *     above the scope. Use $filter=principalId eq {id} to return all role assignments at, above or below the scope
     *     for the specified principal.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role assignments for a scope as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<RoleAssignment> listForScope(
            String vaultBaseUrl, String scope, String filter, Context context) {
        return new PagedIterable<>(
                () -> listForScopeSinglePage(vaultBaseUrl, scope, filter, context),
                nextLink -> listForScopeNextSinglePage(nextLink, vaultBaseUrl, context));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role assignment list operation result along with {@link PagedResponse} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<RoleAssignment>> listForScopeNextSinglePageAsync(String nextLink, String vaultBaseUrl) {
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.listForScopeNext(nextLink, vaultBaseUrl, accept, context))
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role assignment list operation result along with {@link PagedResponse} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<RoleAssignment>> listForScopeNextSinglePageAsync(
            String nextLink, String vaultBaseUrl, Context context) {
        final String accept = "application/json";
        return service.listForScopeNext(nextLink, vaultBaseUrl, accept, context)
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role assignment list operation result along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<RoleAssignment> listForScopeNextSinglePage(String nextLink, String vaultBaseUrl) {
        final String accept = "application/json";
        Response<RoleAssignmentListResult> res =
                service.listForScopeNextSync(nextLink, vaultBaseUrl, accept, Context.NONE);
        return new PagedResponseBase<>(
                res.getRequest(),
                res.getStatusCode(),
                res.getHeaders(),
                res.getValue().getValue(),
                res.getValue().getNextLink(),
                null);
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role assignment list operation result along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<RoleAssignment> listForScopeNextSinglePage(
            String nextLink, String vaultBaseUrl, Context context) {
        final String accept = "application/json";
        Response<RoleAssignmentListResult> res = service.listForScopeNextSync(nextLink, vaultBaseUrl, accept, context);
        return new PagedResponseBase<>(
                res.getRequest(),
                res.getStatusCode(),
                res.getHeaders(),
                res.getValue().getValue(),
                res.getValue().getNextLink(),
                null);
    }
}
