// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.security.keyvault.administration.implementation;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.CookiePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;

/** Initializes a new instance of the KeyVaultAccessControlClient type. */
public final class KeyVaultAccessControlClientImpl {
    /** Api Version. */
    private final String apiVersion;

    /**
     * Gets Api Version.
     *
     * @return the apiVersion value.
     */
    public String getApiVersion() {
        return this.apiVersion;
    }

    /** The HTTP pipeline to send requests through. */
    private final HttpPipeline httpPipeline;

    /**
     * Gets The HTTP pipeline to send requests through.
     *
     * @return the httpPipeline value.
     */
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    /** The serializer to serialize an object into a string. */
    private final SerializerAdapter serializerAdapter;

    /**
     * Gets The serializer to serialize an object into a string.
     *
     * @return the serializerAdapter value.
     */
    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    /** The RoleDefinitionsImpl object to access its operations. */
    private final RoleDefinitionsImpl roleDefinitions;

    /**
     * Gets the RoleDefinitionsImpl object to access its operations.
     *
     * @return the RoleDefinitionsImpl object.
     */
    public RoleDefinitionsImpl getRoleDefinitions() {
        return this.roleDefinitions;
    }

    /** The RoleAssignmentsImpl object to access its operations. */
    private final RoleAssignmentsImpl roleAssignments;

    /**
     * Gets the RoleAssignmentsImpl object to access its operations.
     *
     * @return the RoleAssignmentsImpl object.
     */
    public RoleAssignmentsImpl getRoleAssignments() {
        return this.roleAssignments;
    }

    /**
     * Initializes an instance of KeyVaultAccessControlClient client.
     *
     * @param apiVersion Api Version.
     */
    KeyVaultAccessControlClientImpl(String apiVersion) {
        this(
                new HttpPipelineBuilder()
                        .policies(new UserAgentPolicy(), new RetryPolicy(), new CookiePolicy())
                        .build(),
                JacksonAdapter.createDefaultSerializerAdapter(),
                apiVersion);
    }

    /**
     * Initializes an instance of KeyVaultAccessControlClient client.
     *
     * @param httpPipeline The HTTP pipeline to send requests through.
     * @param apiVersion Api Version.
     */
    KeyVaultAccessControlClientImpl(HttpPipeline httpPipeline, String apiVersion) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), apiVersion);
    }

    /**
     * Initializes an instance of KeyVaultAccessControlClient client.
     *
     * @param httpPipeline The HTTP pipeline to send requests through.
     * @param serializerAdapter The serializer to serialize an object into a string.
     * @param apiVersion Api Version.
     */
    KeyVaultAccessControlClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String apiVersion) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.apiVersion = apiVersion;
        this.roleDefinitions = new RoleDefinitionsImpl(this);
        this.roleAssignments = new RoleAssignmentsImpl(this);
    }
}
