/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.models.VectorQuery;
import com.azure.search.documents.models.VectorQueryKind;
import com.azure.search.documents.models.VectorThreshold;
import java.io.IOException;

public final class VectorizableImageBinaryQuery
extends VectorQuery {
    private VectorQueryKind kind = VectorQueryKind.IMAGE_BINARY;
    private String base64Image;

    @Override
    public VectorQueryKind getKind() {
        return this.kind;
    }

    public String getBase64Image() {
        return this.base64Image;
    }

    public VectorizableImageBinaryQuery setBase64Image(String base64Image) {
        this.base64Image = base64Image;
        return this;
    }

    @Override
    public VectorizableImageBinaryQuery setKNearestNeighborsCount(Integer kNearestNeighborsCount) {
        super.setKNearestNeighborsCount(kNearestNeighborsCount);
        return this;
    }

    @Override
    public VectorizableImageBinaryQuery setFields(String ... fields) {
        super.setFields(fields);
        return this;
    }

    @Override
    public VectorizableImageBinaryQuery setExhaustive(Boolean exhaustive) {
        super.setExhaustive(exhaustive);
        return this;
    }

    @Override
    public VectorizableImageBinaryQuery setOversampling(Double oversampling) {
        super.setOversampling(oversampling);
        return this;
    }

    @Override
    public VectorizableImageBinaryQuery setWeight(Float weight) {
        super.setWeight(weight);
        return this;
    }

    @Override
    public VectorizableImageBinaryQuery setThreshold(VectorThreshold threshold) {
        super.setThreshold(threshold);
        return this;
    }

    @Override
    public VectorizableImageBinaryQuery setFilterOverride(String filterOverride) {
        super.setFilterOverride(filterOverride);
        return this;
    }

    @Override
    public VectorizableImageBinaryQuery setPerDocumentVectorLimit(Integer perDocumentVectorLimit) {
        super.setPerDocumentVectorLimit(perDocumentVectorLimit);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("k", (Number)this.getKNearestNeighborsCount());
        jsonWriter.writeStringField("fields", this.getFields());
        jsonWriter.writeBooleanField("exhaustive", this.isExhaustive());
        jsonWriter.writeNumberField("oversampling", (Number)this.getOversampling());
        jsonWriter.writeNumberField("weight", (Number)this.getWeight());
        jsonWriter.writeJsonField("threshold", (JsonSerializable)this.getThreshold());
        jsonWriter.writeStringField("filterOverride", this.getFilterOverride());
        jsonWriter.writeNumberField("perDocumentVectorLimit", (Number)this.getPerDocumentVectorLimit());
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeStringField("base64Image", this.base64Image);
        return jsonWriter.writeEndObject();
    }

    public static VectorizableImageBinaryQuery fromJson(JsonReader jsonReader) throws IOException {
        return (VectorizableImageBinaryQuery)jsonReader.readObject(reader -> {
            VectorizableImageBinaryQuery deserializedVectorizableImageBinaryQuery = new VectorizableImageBinaryQuery();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("k".equals(fieldName)) {
                    deserializedVectorizableImageBinaryQuery.setKNearestNeighborsCount((Integer)reader.getNullable(JsonReader::getInt));
                    continue;
                }
                if ("fields".equals(fieldName)) {
                    deserializedVectorizableImageBinaryQuery.setFields(reader.getString());
                    continue;
                }
                if ("exhaustive".equals(fieldName)) {
                    deserializedVectorizableImageBinaryQuery.setExhaustive((Boolean)reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("oversampling".equals(fieldName)) {
                    deserializedVectorizableImageBinaryQuery.setOversampling((Double)reader.getNullable(JsonReader::getDouble));
                    continue;
                }
                if ("weight".equals(fieldName)) {
                    deserializedVectorizableImageBinaryQuery.setWeight((Float)reader.getNullable(JsonReader::getFloat));
                    continue;
                }
                if ("threshold".equals(fieldName)) {
                    deserializedVectorizableImageBinaryQuery.setThreshold(VectorThreshold.fromJson(reader));
                    continue;
                }
                if ("filterOverride".equals(fieldName)) {
                    deserializedVectorizableImageBinaryQuery.setFilterOverride(reader.getString());
                    continue;
                }
                if ("perDocumentVectorLimit".equals(fieldName)) {
                    deserializedVectorizableImageBinaryQuery.setPerDocumentVectorLimit((Integer)reader.getNullable(JsonReader::getInt));
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedVectorizableImageBinaryQuery.kind = VectorQueryKind.fromString(reader.getString());
                    continue;
                }
                if ("base64Image".equals(fieldName)) {
                    deserializedVectorizableImageBinaryQuery.base64Image = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVectorizableImageBinaryQuery;
        });
    }
}

