/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.models.SearchScoreThreshold;
import com.azure.search.documents.models.VectorSimilarityThreshold;
import com.azure.search.documents.models.VectorThresholdKind;
import java.io.IOException;

public class VectorThreshold
implements JsonSerializable<VectorThreshold> {
    private VectorThresholdKind kind = VectorThresholdKind.fromString("VectorThreshold");

    public VectorThresholdKind getKind() {
        return this.kind;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        return jsonWriter.writeEndObject();
    }

    public static VectorThreshold fromJson(JsonReader jsonReader) throws IOException {
        return (VectorThreshold)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                VectorThreshold vectorThreshold;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("kind".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("vectorSimilarity".equals(discriminatorValue)) {
                    vectorThreshold = VectorSimilarityThreshold.fromJson(readerToUse.reset());
                    return vectorThreshold;
                }
                if ("searchScore".equals(discriminatorValue)) {
                    vectorThreshold = SearchScoreThreshold.fromJson(readerToUse.reset());
                    return vectorThreshold;
                }
                vectorThreshold = VectorThreshold.fromJsonKnownDiscriminator(readerToUse.reset());
                return vectorThreshold;
            }
        });
    }

    static VectorThreshold fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (VectorThreshold)jsonReader.readObject(reader -> {
            VectorThreshold deserializedVectorThreshold = new VectorThreshold();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("kind".equals(fieldName)) {
                    deserializedVectorThreshold.kind = VectorThresholdKind.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVectorThreshold;
        });
    }
}

