/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.models.VectorQueryKind;
import com.azure.search.documents.models.VectorThreshold;
import com.azure.search.documents.models.VectorizableImageBinaryQuery;
import com.azure.search.documents.models.VectorizableImageUrlQuery;
import com.azure.search.documents.models.VectorizableTextQuery;
import com.azure.search.documents.models.VectorizedQuery;
import java.io.IOException;

public class VectorQuery
implements JsonSerializable<VectorQuery> {
    private VectorQueryKind kind = VectorQueryKind.fromString("VectorQuery");
    private Integer kNearestNeighborsCount;
    private String fields;
    private Boolean exhaustive;
    private Double oversampling;
    private Float weight;
    private VectorThreshold threshold;
    private String filterOverride;
    private Integer perDocumentVectorLimit;

    public VectorQueryKind getKind() {
        return this.kind;
    }

    public Integer getKNearestNeighborsCount() {
        return this.kNearestNeighborsCount;
    }

    public VectorQuery setKNearestNeighborsCount(Integer kNearestNeighborsCount) {
        this.kNearestNeighborsCount = kNearestNeighborsCount;
        return this;
    }

    public String getFields() {
        return this.fields;
    }

    public VectorQuery setFields(String ... fields) {
        this.fields = fields == null ? null : String.join((CharSequence)",", fields);
        return this;
    }

    public Boolean isExhaustive() {
        return this.exhaustive;
    }

    public VectorQuery setExhaustive(Boolean exhaustive) {
        this.exhaustive = exhaustive;
        return this;
    }

    public Double getOversampling() {
        return this.oversampling;
    }

    public VectorQuery setOversampling(Double oversampling) {
        this.oversampling = oversampling;
        return this;
    }

    public Float getWeight() {
        return this.weight;
    }

    public VectorQuery setWeight(Float weight) {
        this.weight = weight;
        return this;
    }

    public VectorThreshold getThreshold() {
        return this.threshold;
    }

    public VectorQuery setThreshold(VectorThreshold threshold) {
        this.threshold = threshold;
        return this;
    }

    public String getFilterOverride() {
        return this.filterOverride;
    }

    public VectorQuery setFilterOverride(String filterOverride) {
        this.filterOverride = filterOverride;
        return this;
    }

    public Integer getPerDocumentVectorLimit() {
        return this.perDocumentVectorLimit;
    }

    public VectorQuery setPerDocumentVectorLimit(Integer perDocumentVectorLimit) {
        this.perDocumentVectorLimit = perDocumentVectorLimit;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeNumberField("k", (Number)this.kNearestNeighborsCount);
        jsonWriter.writeStringField("fields", this.fields);
        jsonWriter.writeBooleanField("exhaustive", this.exhaustive);
        jsonWriter.writeNumberField("oversampling", (Number)this.oversampling);
        jsonWriter.writeNumberField("weight", (Number)this.weight);
        jsonWriter.writeJsonField("threshold", (JsonSerializable)this.threshold);
        jsonWriter.writeStringField("filterOverride", this.filterOverride);
        jsonWriter.writeNumberField("perDocumentVectorLimit", (Number)this.perDocumentVectorLimit);
        return jsonWriter.writeEndObject();
    }

    public static VectorQuery fromJson(JsonReader jsonReader) throws IOException {
        return (VectorQuery)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                VectorQuery vectorQuery;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("kind".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("text".equals(discriminatorValue)) {
                    vectorQuery = VectorizableTextQuery.fromJson(readerToUse.reset());
                    return vectorQuery;
                }
                if ("imageUrl".equals(discriminatorValue)) {
                    vectorQuery = VectorizableImageUrlQuery.fromJson(readerToUse.reset());
                    return vectorQuery;
                }
                if ("imageBinary".equals(discriminatorValue)) {
                    vectorQuery = VectorizableImageBinaryQuery.fromJson(readerToUse.reset());
                    return vectorQuery;
                }
                if ("vector".equals(discriminatorValue)) {
                    vectorQuery = VectorizedQuery.fromJson(readerToUse.reset());
                    return vectorQuery;
                }
                vectorQuery = VectorQuery.fromJsonKnownDiscriminator(readerToUse.reset());
                return vectorQuery;
            }
        });
    }

    static VectorQuery fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (VectorQuery)jsonReader.readObject(reader -> {
            VectorQuery deserializedVectorQuery = new VectorQuery();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("kind".equals(fieldName)) {
                    deserializedVectorQuery.kind = VectorQueryKind.fromString(reader.getString());
                    continue;
                }
                if ("k".equals(fieldName)) {
                    deserializedVectorQuery.kNearestNeighborsCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("fields".equals(fieldName)) {
                    deserializedVectorQuery.fields = reader.getString();
                    continue;
                }
                if ("exhaustive".equals(fieldName)) {
                    deserializedVectorQuery.exhaustive = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("oversampling".equals(fieldName)) {
                    deserializedVectorQuery.oversampling = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("weight".equals(fieldName)) {
                    deserializedVectorQuery.weight = (Float)reader.getNullable(JsonReader::getFloat);
                    continue;
                }
                if ("threshold".equals(fieldName)) {
                    deserializedVectorQuery.threshold = VectorThreshold.fromJson(reader);
                    continue;
                }
                if ("filterOverride".equals(fieldName)) {
                    deserializedVectorQuery.filterOverride = reader.getString();
                    continue;
                }
                if ("perDocumentVectorLimit".equals(fieldName)) {
                    deserializedVectorQuery.perDocumentVectorLimit = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVectorQuery;
        });
    }
}

