/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.SearchIndexerDataIdentity;
import java.io.IOException;

public final class SearchIndexerCache
implements JsonSerializable<SearchIndexerCache> {
    private String id;
    private String storageConnectionString;
    private Boolean enableReprocessing;
    private SearchIndexerDataIdentity identity;

    public String getId() {
        return this.id;
    }

    public SearchIndexerCache setId(String id) {
        this.id = id;
        return this;
    }

    public String getStorageConnectionString() {
        return this.storageConnectionString;
    }

    public SearchIndexerCache setStorageConnectionString(String storageConnectionString) {
        this.storageConnectionString = storageConnectionString;
        return this;
    }

    public Boolean isEnableReprocessing() {
        return this.enableReprocessing;
    }

    public SearchIndexerCache setEnableReprocessing(Boolean enableReprocessing) {
        this.enableReprocessing = enableReprocessing;
        return this;
    }

    public SearchIndexerDataIdentity getIdentity() {
        return this.identity;
    }

    public SearchIndexerCache setIdentity(SearchIndexerDataIdentity identity) {
        this.identity = identity;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("storageConnectionString", this.storageConnectionString);
        jsonWriter.writeBooleanField("enableReprocessing", this.enableReprocessing);
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        return jsonWriter.writeEndObject();
    }

    public static SearchIndexerCache fromJson(JsonReader jsonReader) throws IOException {
        return (SearchIndexerCache)jsonReader.readObject(reader -> {
            SearchIndexerCache deserializedSearchIndexerCache = new SearchIndexerCache();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedSearchIndexerCache.id = reader.getString();
                    continue;
                }
                if ("storageConnectionString".equals(fieldName)) {
                    deserializedSearchIndexerCache.storageConnectionString = reader.getString();
                    continue;
                }
                if ("enableReprocessing".equals(fieldName)) {
                    deserializedSearchIndexerCache.enableReprocessing = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedSearchIndexerCache.identity = SearchIndexerDataIdentity.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSearchIndexerCache;
        });
    }
}

