/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.RescoringOptions;
import com.azure.search.documents.indexes.models.ScalarQuantizationParameters;
import com.azure.search.documents.indexes.models.VectorSearchCompression;
import com.azure.search.documents.indexes.models.VectorSearchCompressionKind;
import java.io.IOException;

public final class ScalarQuantizationCompression
extends VectorSearchCompression {
    private VectorSearchCompressionKind kind = VectorSearchCompressionKind.SCALAR_QUANTIZATION;
    private ScalarQuantizationParameters parameters;

    public ScalarQuantizationCompression(String compressionName) {
        super(compressionName);
    }

    @Override
    public VectorSearchCompressionKind getKind() {
        return this.kind;
    }

    public ScalarQuantizationParameters getParameters() {
        return this.parameters;
    }

    public ScalarQuantizationCompression setParameters(ScalarQuantizationParameters parameters) {
        this.parameters = parameters;
        return this;
    }

    @Override
    public ScalarQuantizationCompression setRerankWithOriginalVectors(Boolean rerankWithOriginalVectors) {
        super.setRerankWithOriginalVectors(rerankWithOriginalVectors);
        return this;
    }

    @Override
    public ScalarQuantizationCompression setDefaultOversampling(Double defaultOversampling) {
        super.setDefaultOversampling(defaultOversampling);
        return this;
    }

    @Override
    public ScalarQuantizationCompression setRescoringOptions(RescoringOptions rescoringOptions) {
        super.setRescoringOptions(rescoringOptions);
        return this;
    }

    @Override
    public ScalarQuantizationCompression setTruncationDimension(Integer truncationDimension) {
        super.setTruncationDimension(truncationDimension);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.getCompressionName());
        jsonWriter.writeBooleanField("rerankWithOriginalVectors", this.isRerankWithOriginalVectors());
        jsonWriter.writeNumberField("defaultOversampling", (Number)this.getDefaultOversampling());
        jsonWriter.writeJsonField("rescoringOptions", (JsonSerializable)this.getRescoringOptions());
        jsonWriter.writeNumberField("truncationDimension", (Number)this.getTruncationDimension());
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeJsonField("scalarQuantizationParameters", (JsonSerializable)this.parameters);
        return jsonWriter.writeEndObject();
    }

    public static ScalarQuantizationCompression fromJson(JsonReader jsonReader) throws IOException {
        return (ScalarQuantizationCompression)jsonReader.readObject(reader -> {
            boolean compressionNameFound = false;
            String compressionName = null;
            Boolean rerankWithOriginalVectors = null;
            Double defaultOversampling = null;
            RescoringOptions rescoringOptions = null;
            Integer truncationDimension = null;
            VectorSearchCompressionKind kind = VectorSearchCompressionKind.SCALAR_QUANTIZATION;
            ScalarQuantizationParameters parameters = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    compressionName = reader.getString();
                    compressionNameFound = true;
                    continue;
                }
                if ("rerankWithOriginalVectors".equals(fieldName)) {
                    rerankWithOriginalVectors = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("defaultOversampling".equals(fieldName)) {
                    defaultOversampling = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("rescoringOptions".equals(fieldName)) {
                    rescoringOptions = RescoringOptions.fromJson(reader);
                    continue;
                }
                if ("truncationDimension".equals(fieldName)) {
                    truncationDimension = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    kind = VectorSearchCompressionKind.fromString(reader.getString());
                    continue;
                }
                if ("scalarQuantizationParameters".equals(fieldName)) {
                    parameters = ScalarQuantizationParameters.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            if (compressionNameFound) {
                ScalarQuantizationCompression deserializedScalarQuantizationCompression = new ScalarQuantizationCompression(compressionName);
                deserializedScalarQuantizationCompression.setRerankWithOriginalVectors(rerankWithOriginalVectors);
                deserializedScalarQuantizationCompression.setDefaultOversampling(defaultOversampling);
                deserializedScalarQuantizationCompression.setRescoringOptions(rescoringOptions);
                deserializedScalarQuantizationCompression.setTruncationDimension(truncationDimension);
                deserializedScalarQuantizationCompression.kind = kind;
                deserializedScalarQuantizationCompression.parameters = parameters;
                return deserializedScalarQuantizationCompression;
            }
            throw new IllegalStateException("Missing required property: name");
        });
    }
}

