/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.CustomNormalizer;
import java.io.IOException;

public class LexicalNormalizer
implements JsonSerializable<LexicalNormalizer> {
    private String odataType = "LexicalNormalizer";
    private final String name;

    public LexicalNormalizer(String name) {
        this.name = name;
    }

    public String getOdataType() {
        return this.odataType;
    }

    public String getName() {
        return this.name;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("@odata.type", this.odataType);
        return jsonWriter.writeEndObject();
    }

    public static LexicalNormalizer fromJson(JsonReader jsonReader) throws IOException {
        return (LexicalNormalizer)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                LexicalNormalizer lexicalNormalizer;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("@odata.type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("#Microsoft.Azure.Search.CustomNormalizer".equals(discriminatorValue)) {
                    lexicalNormalizer = CustomNormalizer.fromJson(readerToUse.reset());
                    return lexicalNormalizer;
                }
                lexicalNormalizer = LexicalNormalizer.fromJsonKnownDiscriminator(readerToUse.reset());
                return lexicalNormalizer;
            }
        });
    }

    static LexicalNormalizer fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (LexicalNormalizer)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            String odataType = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("@odata.type".equals(fieldName)) {
                    odataType = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound) {
                LexicalNormalizer deserializedLexicalNormalizer = new LexicalNormalizer(name);
                deserializedLexicalNormalizer.odataType = odataType;
                return deserializedLexicalNormalizer;
            }
            throw new IllegalStateException("Missing required property: name");
        });
    }
}

