/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class KnowledgeSourceReference
implements JsonSerializable<KnowledgeSourceReference> {
    private final String name;
    private Boolean includeReferences;
    private Boolean includeReferenceSourceData;
    private Boolean alwaysQuerySource;
    private Integer maxSubQueries;
    private Float rerankerThreshold;

    public KnowledgeSourceReference(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Boolean isIncludeReferences() {
        return this.includeReferences;
    }

    public KnowledgeSourceReference setIncludeReferences(Boolean includeReferences) {
        this.includeReferences = includeReferences;
        return this;
    }

    public Boolean isIncludeReferenceSourceData() {
        return this.includeReferenceSourceData;
    }

    public KnowledgeSourceReference setIncludeReferenceSourceData(Boolean includeReferenceSourceData) {
        this.includeReferenceSourceData = includeReferenceSourceData;
        return this;
    }

    public Boolean isAlwaysQuerySource() {
        return this.alwaysQuerySource;
    }

    public KnowledgeSourceReference setAlwaysQuerySource(Boolean alwaysQuerySource) {
        this.alwaysQuerySource = alwaysQuerySource;
        return this;
    }

    public Integer getMaxSubQueries() {
        return this.maxSubQueries;
    }

    public KnowledgeSourceReference setMaxSubQueries(Integer maxSubQueries) {
        this.maxSubQueries = maxSubQueries;
        return this;
    }

    public Float getRerankerThreshold() {
        return this.rerankerThreshold;
    }

    public KnowledgeSourceReference setRerankerThreshold(Float rerankerThreshold) {
        this.rerankerThreshold = rerankerThreshold;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeBooleanField("includeReferences", this.includeReferences);
        jsonWriter.writeBooleanField("includeReferenceSourceData", this.includeReferenceSourceData);
        jsonWriter.writeBooleanField("alwaysQuerySource", this.alwaysQuerySource);
        jsonWriter.writeNumberField("maxSubQueries", (Number)this.maxSubQueries);
        jsonWriter.writeNumberField("rerankerThreshold", (Number)this.rerankerThreshold);
        return jsonWriter.writeEndObject();
    }

    public static KnowledgeSourceReference fromJson(JsonReader jsonReader) throws IOException {
        return (KnowledgeSourceReference)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            Boolean includeReferences = null;
            Boolean includeReferenceSourceData = null;
            Boolean alwaysQuerySource = null;
            Integer maxSubQueries = null;
            Float rerankerThreshold = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("includeReferences".equals(fieldName)) {
                    includeReferences = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("includeReferenceSourceData".equals(fieldName)) {
                    includeReferenceSourceData = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("alwaysQuerySource".equals(fieldName)) {
                    alwaysQuerySource = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("maxSubQueries".equals(fieldName)) {
                    maxSubQueries = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("rerankerThreshold".equals(fieldName)) {
                    rerankerThreshold = (Float)reader.getNullable(JsonReader::getFloat);
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound) {
                KnowledgeSourceReference deserializedKnowledgeSourceReference = new KnowledgeSourceReference(name);
                deserializedKnowledgeSourceReference.includeReferences = includeReferences;
                deserializedKnowledgeSourceReference.includeReferenceSourceData = includeReferenceSourceData;
                deserializedKnowledgeSourceReference.alwaysQuerySource = alwaysQuerySource;
                deserializedKnowledgeSourceReference.maxSubQueries = maxSubQueries;
                deserializedKnowledgeSourceReference.rerankerThreshold = rerankerThreshold;
                return deserializedKnowledgeSourceReference;
            }
            throw new IllegalStateException("Missing required property: name");
        });
    }
}

