/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.BlobIndexerDataToExtract;
import com.azure.search.documents.indexes.models.BlobIndexerImageAction;
import com.azure.search.documents.indexes.models.BlobIndexerParsingMode;
import com.azure.search.documents.indexes.models.BlobIndexerPdfTextRotationAlgorithm;
import com.azure.search.documents.indexes.models.IndexerExecutionEnvironment;
import com.azure.search.documents.indexes.models.MarkdownHeaderDepth;
import com.azure.search.documents.indexes.models.MarkdownParsingSubmode;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class IndexingParametersConfiguration
implements JsonSerializable<IndexingParametersConfiguration> {
    private BlobIndexerParsingMode parsingMode;
    private String excludedFileNameExtensions;
    private String indexedFileNameExtensions;
    private Boolean failOnUnsupportedContentType;
    private Boolean failOnUnprocessableDocument;
    private Boolean indexStorageMetadataOnlyForOversizedDocuments;
    private String delimitedTextHeaders;
    private String delimitedTextDelimiter;
    private Boolean firstLineContainsHeaders;
    private MarkdownParsingSubmode markdownParsingSubmode;
    private MarkdownHeaderDepth markdownHeaderDepth;
    private String documentRoot;
    private BlobIndexerDataToExtract dataToExtract;
    private BlobIndexerImageAction imageAction;
    private Boolean allowSkillsetToReadFileData;
    private BlobIndexerPdfTextRotationAlgorithm pdfTextRotationAlgorithm;
    private IndexerExecutionEnvironment executionEnvironment;
    private String queryTimeout;
    private Map<String, Object> additionalProperties;

    public BlobIndexerParsingMode getParsingMode() {
        return this.parsingMode;
    }

    public IndexingParametersConfiguration setParsingMode(BlobIndexerParsingMode parsingMode) {
        this.parsingMode = parsingMode;
        return this;
    }

    public String getExcludedFileNameExtensions() {
        return this.excludedFileNameExtensions;
    }

    public IndexingParametersConfiguration setExcludedFileNameExtensions(String excludedFileNameExtensions) {
        this.excludedFileNameExtensions = excludedFileNameExtensions;
        return this;
    }

    public String getIndexedFileNameExtensions() {
        return this.indexedFileNameExtensions;
    }

    public IndexingParametersConfiguration setIndexedFileNameExtensions(String indexedFileNameExtensions) {
        this.indexedFileNameExtensions = indexedFileNameExtensions;
        return this;
    }

    public Boolean isFailOnUnsupportedContentType() {
        return this.failOnUnsupportedContentType;
    }

    public IndexingParametersConfiguration setFailOnUnsupportedContentType(Boolean failOnUnsupportedContentType) {
        this.failOnUnsupportedContentType = failOnUnsupportedContentType;
        return this;
    }

    public Boolean isFailOnUnprocessableDocument() {
        return this.failOnUnprocessableDocument;
    }

    public IndexingParametersConfiguration setFailOnUnprocessableDocument(Boolean failOnUnprocessableDocument) {
        this.failOnUnprocessableDocument = failOnUnprocessableDocument;
        return this;
    }

    public Boolean isIndexStorageMetadataOnlyForOversizedDocuments() {
        return this.indexStorageMetadataOnlyForOversizedDocuments;
    }

    public IndexingParametersConfiguration setIndexStorageMetadataOnlyForOversizedDocuments(Boolean indexStorageMetadataOnlyForOversizedDocuments) {
        this.indexStorageMetadataOnlyForOversizedDocuments = indexStorageMetadataOnlyForOversizedDocuments;
        return this;
    }

    public String getDelimitedTextHeaders() {
        return this.delimitedTextHeaders;
    }

    public IndexingParametersConfiguration setDelimitedTextHeaders(String delimitedTextHeaders) {
        this.delimitedTextHeaders = delimitedTextHeaders;
        return this;
    }

    public String getDelimitedTextDelimiter() {
        return this.delimitedTextDelimiter;
    }

    public IndexingParametersConfiguration setDelimitedTextDelimiter(String delimitedTextDelimiter) {
        this.delimitedTextDelimiter = delimitedTextDelimiter;
        return this;
    }

    public Boolean isFirstLineContainsHeaders() {
        return this.firstLineContainsHeaders;
    }

    public IndexingParametersConfiguration setFirstLineContainsHeaders(Boolean firstLineContainsHeaders) {
        this.firstLineContainsHeaders = firstLineContainsHeaders;
        return this;
    }

    public MarkdownParsingSubmode getMarkdownParsingSubmode() {
        return this.markdownParsingSubmode;
    }

    public IndexingParametersConfiguration setMarkdownParsingSubmode(MarkdownParsingSubmode markdownParsingSubmode) {
        this.markdownParsingSubmode = markdownParsingSubmode;
        return this;
    }

    public MarkdownHeaderDepth getMarkdownHeaderDepth() {
        return this.markdownHeaderDepth;
    }

    public IndexingParametersConfiguration setMarkdownHeaderDepth(MarkdownHeaderDepth markdownHeaderDepth) {
        this.markdownHeaderDepth = markdownHeaderDepth;
        return this;
    }

    public String getDocumentRoot() {
        return this.documentRoot;
    }

    public IndexingParametersConfiguration setDocumentRoot(String documentRoot) {
        this.documentRoot = documentRoot;
        return this;
    }

    public BlobIndexerDataToExtract getDataToExtract() {
        return this.dataToExtract;
    }

    public IndexingParametersConfiguration setDataToExtract(BlobIndexerDataToExtract dataToExtract) {
        this.dataToExtract = dataToExtract;
        return this;
    }

    public BlobIndexerImageAction getImageAction() {
        return this.imageAction;
    }

    public IndexingParametersConfiguration setImageAction(BlobIndexerImageAction imageAction) {
        this.imageAction = imageAction;
        return this;
    }

    public Boolean isAllowSkillsetToReadFileData() {
        return this.allowSkillsetToReadFileData;
    }

    public IndexingParametersConfiguration setAllowSkillsetToReadFileData(Boolean allowSkillsetToReadFileData) {
        this.allowSkillsetToReadFileData = allowSkillsetToReadFileData;
        return this;
    }

    public BlobIndexerPdfTextRotationAlgorithm getPdfTextRotationAlgorithm() {
        return this.pdfTextRotationAlgorithm;
    }

    public IndexingParametersConfiguration setPdfTextRotationAlgorithm(BlobIndexerPdfTextRotationAlgorithm pdfTextRotationAlgorithm) {
        this.pdfTextRotationAlgorithm = pdfTextRotationAlgorithm;
        return this;
    }

    public IndexerExecutionEnvironment getExecutionEnvironment() {
        return this.executionEnvironment;
    }

    public IndexingParametersConfiguration setExecutionEnvironment(IndexerExecutionEnvironment executionEnvironment) {
        this.executionEnvironment = executionEnvironment;
        return this;
    }

    public String getQueryTimeout() {
        return this.queryTimeout;
    }

    public IndexingParametersConfiguration setQueryTimeout(String queryTimeout) {
        this.queryTimeout = queryTimeout;
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public IndexingParametersConfiguration setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("parsingMode", this.parsingMode == null ? null : this.parsingMode.toString());
        jsonWriter.writeStringField("excludedFileNameExtensions", this.excludedFileNameExtensions);
        jsonWriter.writeStringField("indexedFileNameExtensions", this.indexedFileNameExtensions);
        jsonWriter.writeBooleanField("failOnUnsupportedContentType", this.failOnUnsupportedContentType);
        jsonWriter.writeBooleanField("failOnUnprocessableDocument", this.failOnUnprocessableDocument);
        jsonWriter.writeBooleanField("indexStorageMetadataOnlyForOversizedDocuments", this.indexStorageMetadataOnlyForOversizedDocuments);
        jsonWriter.writeStringField("delimitedTextHeaders", this.delimitedTextHeaders);
        jsonWriter.writeStringField("delimitedTextDelimiter", this.delimitedTextDelimiter);
        jsonWriter.writeBooleanField("firstLineContainsHeaders", this.firstLineContainsHeaders);
        jsonWriter.writeStringField("markdownParsingSubmode", this.markdownParsingSubmode == null ? null : this.markdownParsingSubmode.toString());
        jsonWriter.writeStringField("markdownHeaderDepth", this.markdownHeaderDepth == null ? null : this.markdownHeaderDepth.toString());
        jsonWriter.writeStringField("documentRoot", this.documentRoot);
        jsonWriter.writeStringField("dataToExtract", this.dataToExtract == null ? null : this.dataToExtract.toString());
        jsonWriter.writeStringField("imageAction", this.imageAction == null ? null : this.imageAction.toString());
        jsonWriter.writeBooleanField("allowSkillsetToReadFileData", this.allowSkillsetToReadFileData);
        jsonWriter.writeStringField("pdfTextRotationAlgorithm", this.pdfTextRotationAlgorithm == null ? null : this.pdfTextRotationAlgorithm.toString());
        jsonWriter.writeStringField("executionEnvironment", this.executionEnvironment == null ? null : this.executionEnvironment.toString());
        jsonWriter.writeStringField("queryTimeout", this.queryTimeout);
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static IndexingParametersConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (IndexingParametersConfiguration)jsonReader.readObject(reader -> {
            IndexingParametersConfiguration deserializedIndexingParametersConfiguration = new IndexingParametersConfiguration();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("parsingMode".equals(fieldName)) {
                    deserializedIndexingParametersConfiguration.parsingMode = BlobIndexerParsingMode.fromString(reader.getString());
                    continue;
                }
                if ("excludedFileNameExtensions".equals(fieldName)) {
                    deserializedIndexingParametersConfiguration.excludedFileNameExtensions = reader.getString();
                    continue;
                }
                if ("indexedFileNameExtensions".equals(fieldName)) {
                    deserializedIndexingParametersConfiguration.indexedFileNameExtensions = reader.getString();
                    continue;
                }
                if ("failOnUnsupportedContentType".equals(fieldName)) {
                    deserializedIndexingParametersConfiguration.failOnUnsupportedContentType = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("failOnUnprocessableDocument".equals(fieldName)) {
                    deserializedIndexingParametersConfiguration.failOnUnprocessableDocument = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("indexStorageMetadataOnlyForOversizedDocuments".equals(fieldName)) {
                    deserializedIndexingParametersConfiguration.indexStorageMetadataOnlyForOversizedDocuments = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("delimitedTextHeaders".equals(fieldName)) {
                    deserializedIndexingParametersConfiguration.delimitedTextHeaders = reader.getString();
                    continue;
                }
                if ("delimitedTextDelimiter".equals(fieldName)) {
                    deserializedIndexingParametersConfiguration.delimitedTextDelimiter = reader.getString();
                    continue;
                }
                if ("firstLineContainsHeaders".equals(fieldName)) {
                    deserializedIndexingParametersConfiguration.firstLineContainsHeaders = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("markdownParsingSubmode".equals(fieldName)) {
                    deserializedIndexingParametersConfiguration.markdownParsingSubmode = MarkdownParsingSubmode.fromString(reader.getString());
                    continue;
                }
                if ("markdownHeaderDepth".equals(fieldName)) {
                    deserializedIndexingParametersConfiguration.markdownHeaderDepth = MarkdownHeaderDepth.fromString(reader.getString());
                    continue;
                }
                if ("documentRoot".equals(fieldName)) {
                    deserializedIndexingParametersConfiguration.documentRoot = reader.getString();
                    continue;
                }
                if ("dataToExtract".equals(fieldName)) {
                    deserializedIndexingParametersConfiguration.dataToExtract = BlobIndexerDataToExtract.fromString(reader.getString());
                    continue;
                }
                if ("imageAction".equals(fieldName)) {
                    deserializedIndexingParametersConfiguration.imageAction = BlobIndexerImageAction.fromString(reader.getString());
                    continue;
                }
                if ("allowSkillsetToReadFileData".equals(fieldName)) {
                    deserializedIndexingParametersConfiguration.allowSkillsetToReadFileData = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("pdfTextRotationAlgorithm".equals(fieldName)) {
                    deserializedIndexingParametersConfiguration.pdfTextRotationAlgorithm = BlobIndexerPdfTextRotationAlgorithm.fromString(reader.getString());
                    continue;
                }
                if ("executionEnvironment".equals(fieldName)) {
                    deserializedIndexingParametersConfiguration.executionEnvironment = IndexerExecutionEnvironment.fromString(reader.getString());
                    continue;
                }
                if ("queryTimeout".equals(fieldName)) {
                    deserializedIndexingParametersConfiguration.queryTimeout = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedIndexingParametersConfiguration.additionalProperties = additionalProperties;
            return deserializedIndexingParametersConfiguration;
        });
    }
}

