/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.InputFieldMappingEntry;
import com.azure.search.documents.indexes.models.OutputFieldMappingEntry;
import com.azure.search.documents.indexes.models.SearchIndexerSkill;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;

public final class AzureMachineLearningSkill
extends SearchIndexerSkill {
    private String odataType = "#Microsoft.Skills.Custom.AmlSkill";
    private String scoringUri;
    private String authenticationKey;
    private String resourceId;
    private Duration timeout;
    private String region;
    private Integer degreeOfParallelism;

    public AzureMachineLearningSkill(List<InputFieldMappingEntry> inputs, List<OutputFieldMappingEntry> outputs) {
        super(inputs, outputs);
    }

    @Override
    public String getOdataType() {
        return this.odataType;
    }

    public String getScoringUri() {
        return this.scoringUri;
    }

    public AzureMachineLearningSkill setScoringUri(String scoringUri) {
        this.scoringUri = scoringUri;
        return this;
    }

    public String getAuthenticationKey() {
        return this.authenticationKey;
    }

    public AzureMachineLearningSkill setAuthenticationKey(String authenticationKey) {
        this.authenticationKey = authenticationKey;
        return this;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public AzureMachineLearningSkill setResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    public AzureMachineLearningSkill setTimeout(Duration timeout) {
        this.timeout = timeout;
        return this;
    }

    public String getRegion() {
        return this.region;
    }

    public AzureMachineLearningSkill setRegion(String region) {
        this.region = region;
        return this;
    }

    public Integer getDegreeOfParallelism() {
        return this.degreeOfParallelism;
    }

    public AzureMachineLearningSkill setDegreeOfParallelism(Integer degreeOfParallelism) {
        this.degreeOfParallelism = degreeOfParallelism;
        return this;
    }

    @Override
    public AzureMachineLearningSkill setName(String name) {
        super.setName(name);
        return this;
    }

    @Override
    public AzureMachineLearningSkill setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public AzureMachineLearningSkill setContext(String context) {
        super.setContext(context);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("inputs", this.getInputs(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("outputs", this.getOutputs(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeStringField("context", this.getContext());
        jsonWriter.writeStringField("@odata.type", this.odataType);
        jsonWriter.writeStringField("uri", this.scoringUri);
        jsonWriter.writeStringField("key", this.authenticationKey);
        jsonWriter.writeStringField("resourceId", this.resourceId);
        jsonWriter.writeStringField("timeout", CoreUtils.durationToStringWithDays((Duration)this.timeout));
        jsonWriter.writeStringField("region", this.region);
        jsonWriter.writeNumberField("degreeOfParallelism", (Number)this.degreeOfParallelism);
        return jsonWriter.writeEndObject();
    }

    public static AzureMachineLearningSkill fromJson(JsonReader jsonReader) throws IOException {
        return (AzureMachineLearningSkill)jsonReader.readObject(reader -> {
            boolean inputsFound = false;
            List inputs = null;
            boolean outputsFound = false;
            List outputs = null;
            String name = null;
            String description = null;
            String context = null;
            String odataType = "#Microsoft.Skills.Custom.AmlSkill";
            String scoringUri = null;
            String authenticationKey = null;
            String resourceId = null;
            Duration timeout = null;
            String region = null;
            Integer degreeOfParallelism = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("inputs".equals(fieldName)) {
                    inputs = reader.readArray(reader1 -> InputFieldMappingEntry.fromJson(reader1));
                    inputsFound = true;
                    continue;
                }
                if ("outputs".equals(fieldName)) {
                    outputs = reader.readArray(reader1 -> OutputFieldMappingEntry.fromJson(reader1));
                    outputsFound = true;
                    continue;
                }
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    description = reader.getString();
                    continue;
                }
                if ("context".equals(fieldName)) {
                    context = reader.getString();
                    continue;
                }
                if ("@odata.type".equals(fieldName)) {
                    odataType = reader.getString();
                    continue;
                }
                if ("uri".equals(fieldName)) {
                    scoringUri = reader.getString();
                    continue;
                }
                if ("key".equals(fieldName)) {
                    authenticationKey = reader.getString();
                    continue;
                }
                if ("resourceId".equals(fieldName)) {
                    resourceId = reader.getString();
                    continue;
                }
                if ("timeout".equals(fieldName)) {
                    timeout = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                if ("region".equals(fieldName)) {
                    region = reader.getString();
                    continue;
                }
                if ("degreeOfParallelism".equals(fieldName)) {
                    degreeOfParallelism = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            if (inputsFound && outputsFound) {
                AzureMachineLearningSkill deserializedAzureMachineLearningSkill = new AzureMachineLearningSkill(inputs, outputs);
                deserializedAzureMachineLearningSkill.setName(name);
                deserializedAzureMachineLearningSkill.setDescription(description);
                deserializedAzureMachineLearningSkill.setContext(context);
                deserializedAzureMachineLearningSkill.odataType = odataType;
                deserializedAzureMachineLearningSkill.scoringUri = scoringUri;
                deserializedAzureMachineLearningSkill.authenticationKey = authenticationKey;
                deserializedAzureMachineLearningSkill.resourceId = resourceId;
                deserializedAzureMachineLearningSkill.timeout = timeout;
                deserializedAzureMachineLearningSkill.region = region;
                deserializedAzureMachineLearningSkill.degreeOfParallelism = degreeOfParallelism;
                return deserializedAzureMachineLearningSkill;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!inputsFound) {
                missingProperties.add("inputs");
            }
            if (!outputsFound) {
                missingProperties.add("outputs");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

