/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.AzureBlobKnowledgeSourceParameters;
import com.azure.search.documents.indexes.models.KnowledgeSource;
import com.azure.search.documents.indexes.models.KnowledgeSourceKind;
import com.azure.search.documents.indexes.models.SearchResourceEncryptionKey;
import java.io.IOException;
import java.util.ArrayList;

public final class AzureBlobKnowledgeSource
extends KnowledgeSource {
    private KnowledgeSourceKind kind = KnowledgeSourceKind.AZURE_BLOB;
    private final AzureBlobKnowledgeSourceParameters azureBlobParameters;

    public AzureBlobKnowledgeSource(String name, AzureBlobKnowledgeSourceParameters azureBlobParameters) {
        super(name);
        this.azureBlobParameters = azureBlobParameters;
    }

    @Override
    public KnowledgeSourceKind getKind() {
        return this.kind;
    }

    public AzureBlobKnowledgeSourceParameters getAzureBlobParameters() {
        return this.azureBlobParameters;
    }

    @Override
    public AzureBlobKnowledgeSource setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public AzureBlobKnowledgeSource setETag(String eTag) {
        super.setETag(eTag);
        return this;
    }

    @Override
    public AzureBlobKnowledgeSource setEncryptionKey(SearchResourceEncryptionKey encryptionKey) {
        super.setEncryptionKey(encryptionKey);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeStringField("@odata.etag", this.getETag());
        jsonWriter.writeJsonField("encryptionKey", (JsonSerializable)this.getEncryptionKey());
        jsonWriter.writeJsonField("azureBlobParameters", (JsonSerializable)this.azureBlobParameters);
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        return jsonWriter.writeEndObject();
    }

    public static AzureBlobKnowledgeSource fromJson(JsonReader jsonReader) throws IOException {
        return (AzureBlobKnowledgeSource)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            String description = null;
            String eTag = null;
            SearchResourceEncryptionKey encryptionKey = null;
            boolean azureBlobParametersFound = false;
            AzureBlobKnowledgeSourceParameters azureBlobParameters = null;
            KnowledgeSourceKind kind = KnowledgeSourceKind.AZURE_BLOB;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("description".equals(fieldName)) {
                    description = reader.getString();
                    continue;
                }
                if ("@odata.etag".equals(fieldName)) {
                    eTag = reader.getString();
                    continue;
                }
                if ("encryptionKey".equals(fieldName)) {
                    encryptionKey = SearchResourceEncryptionKey.fromJson(reader);
                    continue;
                }
                if ("azureBlobParameters".equals(fieldName)) {
                    azureBlobParameters = AzureBlobKnowledgeSourceParameters.fromJson(reader);
                    azureBlobParametersFound = true;
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    kind = KnowledgeSourceKind.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound && azureBlobParametersFound) {
                AzureBlobKnowledgeSource deserializedAzureBlobKnowledgeSource = new AzureBlobKnowledgeSource(name, azureBlobParameters);
                deserializedAzureBlobKnowledgeSource.setDescription(description);
                deserializedAzureBlobKnowledgeSource.setETag(eTag);
                deserializedAzureBlobKnowledgeSource.setEncryptionKey(encryptionKey);
                deserializedAzureBlobKnowledgeSource.kind = kind;
                return deserializedAzureBlobKnowledgeSource;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!nameFound) {
                missingProperties.add("name");
            }
            if (!azureBlobParametersFound) {
                missingProperties.add("azureBlobParameters");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

