/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.agents.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.agents.models.KnowledgeAgentMessageContent;
import com.azure.search.documents.agents.models.KnowledgeAgentMessageContentType;
import com.azure.search.documents.agents.models.KnowledgeAgentMessageImageContentImage;
import java.io.IOException;

public final class KnowledgeAgentMessageImageContent
extends KnowledgeAgentMessageContent {
    private KnowledgeAgentMessageContentType type = KnowledgeAgentMessageContentType.IMAGE;
    private final KnowledgeAgentMessageImageContentImage image;

    public KnowledgeAgentMessageImageContent(KnowledgeAgentMessageImageContentImage image) {
        this.image = image;
    }

    @Override
    public KnowledgeAgentMessageContentType getType() {
        return this.type;
    }

    public KnowledgeAgentMessageImageContentImage getImage() {
        return this.image;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("image", (JsonSerializable)this.image);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static KnowledgeAgentMessageImageContent fromJson(JsonReader jsonReader) throws IOException {
        return (KnowledgeAgentMessageImageContent)jsonReader.readObject(reader -> {
            boolean imageFound = false;
            KnowledgeAgentMessageImageContentImage image = null;
            KnowledgeAgentMessageContentType type = KnowledgeAgentMessageContentType.IMAGE;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("image".equals(fieldName)) {
                    image = KnowledgeAgentMessageImageContentImage.fromJson(reader);
                    imageFound = true;
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = KnowledgeAgentMessageContentType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            if (imageFound) {
                KnowledgeAgentMessageImageContent deserializedKnowledgeAgentMessageImageContent = new KnowledgeAgentMessageImageContent(image);
                deserializedKnowledgeAgentMessageImageContent.type = type;
                return deserializedKnowledgeAgentMessageImageContent;
            }
            throw new IllegalStateException("Missing required property: image");
        });
    }
}

