/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.TokenFilter;
import java.io.IOException;

public final class UniqueTokenFilter
extends TokenFilter {
    private String odataType = "#Microsoft.Azure.Search.UniqueTokenFilter";
    private Boolean onlyOnSamePosition;

    public UniqueTokenFilter(String name) {
        super(name);
    }

    @Override
    public String getOdataType() {
        return this.odataType;
    }

    public Boolean isOnlyOnSamePosition() {
        return this.onlyOnSamePosition;
    }

    public UniqueTokenFilter setOnlyOnSamePosition(Boolean onlyOnSamePosition) {
        this.onlyOnSamePosition = onlyOnSamePosition;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeStringField("@odata.type", this.odataType);
        jsonWriter.writeBooleanField("onlyOnSamePosition", this.onlyOnSamePosition);
        return jsonWriter.writeEndObject();
    }

    public static UniqueTokenFilter fromJson(JsonReader jsonReader) throws IOException {
        return (UniqueTokenFilter)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            String odataType = "#Microsoft.Azure.Search.UniqueTokenFilter";
            Boolean onlyOnSamePosition = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("@odata.type".equals(fieldName)) {
                    odataType = reader.getString();
                    continue;
                }
                if ("onlyOnSamePosition".equals(fieldName)) {
                    onlyOnSamePosition = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound) {
                UniqueTokenFilter deserializedUniqueTokenFilter = new UniqueTokenFilter(name);
                deserializedUniqueTokenFilter.odataType = odataType;
                deserializedUniqueTokenFilter.onlyOnSamePosition = onlyOnSamePosition;
                return deserializedUniqueTokenFilter;
            }
            throw new IllegalStateException("Missing required property: name");
        });
    }
}

