/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.TokenFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class DictionaryDecompounderTokenFilter
extends TokenFilter {
    private String odataType = "#Microsoft.Azure.Search.DictionaryDecompounderTokenFilter";
    private final List<String> wordList;
    private Integer minWordSize;
    private Integer minSubwordSize;
    private Integer maxSubwordSize;
    private Boolean onlyLongestMatched;

    public DictionaryDecompounderTokenFilter(String name, List<String> wordList) {
        super(name);
        this.wordList = wordList;
    }

    @Override
    public String getOdataType() {
        return this.odataType;
    }

    public List<String> getWordList() {
        return this.wordList;
    }

    public Integer getMinWordSize() {
        return this.minWordSize;
    }

    public DictionaryDecompounderTokenFilter setMinWordSize(Integer minWordSize) {
        this.minWordSize = minWordSize;
        return this;
    }

    public Integer getMinSubwordSize() {
        return this.minSubwordSize;
    }

    public DictionaryDecompounderTokenFilter setMinSubwordSize(Integer minSubwordSize) {
        this.minSubwordSize = minSubwordSize;
        return this;
    }

    public Integer getMaxSubwordSize() {
        return this.maxSubwordSize;
    }

    public DictionaryDecompounderTokenFilter setMaxSubwordSize(Integer maxSubwordSize) {
        this.maxSubwordSize = maxSubwordSize;
        return this;
    }

    public Boolean isOnlyLongestMatched() {
        return this.onlyLongestMatched;
    }

    public DictionaryDecompounderTokenFilter setOnlyLongestMatched(Boolean onlyLongestMatched) {
        this.onlyLongestMatched = onlyLongestMatched;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeArrayField("wordList", this.wordList, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("@odata.type", this.odataType);
        jsonWriter.writeNumberField("minWordSize", (Number)this.minWordSize);
        jsonWriter.writeNumberField("minSubwordSize", (Number)this.minSubwordSize);
        jsonWriter.writeNumberField("maxSubwordSize", (Number)this.maxSubwordSize);
        jsonWriter.writeBooleanField("onlyLongestMatch", this.onlyLongestMatched);
        return jsonWriter.writeEndObject();
    }

    public static DictionaryDecompounderTokenFilter fromJson(JsonReader jsonReader) throws IOException {
        return (DictionaryDecompounderTokenFilter)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            boolean wordListFound = false;
            List wordList = null;
            String odataType = "#Microsoft.Azure.Search.DictionaryDecompounderTokenFilter";
            Integer minWordSize = null;
            Integer minSubwordSize = null;
            Integer maxSubwordSize = null;
            Boolean onlyLongestMatched = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("wordList".equals(fieldName)) {
                    wordList = reader.readArray(reader1 -> reader1.getString());
                    wordListFound = true;
                    continue;
                }
                if ("@odata.type".equals(fieldName)) {
                    odataType = reader.getString();
                    continue;
                }
                if ("minWordSize".equals(fieldName)) {
                    minWordSize = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("minSubwordSize".equals(fieldName)) {
                    minSubwordSize = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("maxSubwordSize".equals(fieldName)) {
                    maxSubwordSize = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("onlyLongestMatch".equals(fieldName)) {
                    onlyLongestMatched = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound && wordListFound) {
                DictionaryDecompounderTokenFilter deserializedDictionaryDecompounderTokenFilter = new DictionaryDecompounderTokenFilter(name, wordList);
                deserializedDictionaryDecompounderTokenFilter.odataType = odataType;
                deserializedDictionaryDecompounderTokenFilter.minWordSize = minWordSize;
                deserializedDictionaryDecompounderTokenFilter.minSubwordSize = minSubwordSize;
                deserializedDictionaryDecompounderTokenFilter.maxSubwordSize = maxSubwordSize;
                deserializedDictionaryDecompounderTokenFilter.onlyLongestMatched = onlyLongestMatched;
                return deserializedDictionaryDecompounderTokenFilter;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!nameFound) {
                missingProperties.add("name");
            }
            if (!wordListFound) {
                missingProperties.add("wordList");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

