/*
 * Decompiled with CFR 0.152.
 */
package com.azure.mixedreality.authentication.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.CookiePolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.mixedreality.authentication.implementation.models.GetTokenResponse;
import com.azure.mixedreality.authentication.implementation.models.TokenRequestOptions;
import java.util.UUID;
import reactor.core.publisher.Mono;

public final class MixedRealityStsRestClientImpl {
    private final MixedRealityStsRestClientService service;
    private final String host;
    private final String apiVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;

    public String getHost() {
        return this.host;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    MixedRealityStsRestClientImpl(String host, String apiVersion) {
        this(new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy(), new CookiePolicy()}).build(), JacksonAdapter.createDefaultSerializerAdapter(), host, apiVersion);
    }

    MixedRealityStsRestClientImpl(HttpPipeline httpPipeline, String host, String apiVersion) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), host, apiVersion);
    }

    MixedRealityStsRestClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String host, String apiVersion) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.host = host;
        this.apiVersion = apiVersion;
        this.service = (MixedRealityStsRestClientService)RestProxy.create(MixedRealityStsRestClientService.class, (HttpPipeline)this.httpPipeline, (SerializerAdapter)this.getSerializerAdapter());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<GetTokenResponse> getTokenWithResponseAsync(UUID accountId, TokenRequestOptions tokenRequestOptions, Context context) {
        String accept = "application/json";
        String clientRequestIdInternal = null;
        if (tokenRequestOptions != null) {
            clientRequestIdInternal = tokenRequestOptions.getClientRequestId();
        }
        String clientRequestId = clientRequestIdInternal;
        return this.service.getToken(this.getHost(), accountId, clientRequestId, this.getApiVersion(), "application/json", context);
    }

    @Host(value="{$host}")
    @ServiceInterface(name="MixedRealityStsRestC")
    public static interface MixedRealityStsRestClientService {
        @Get(value="/Accounts/{accountId}/token")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<GetTokenResponse> getToken(@HostParam(value="$host") String var1, @PathParam(value="accountId") UUID var2, @HeaderParam(value="X-MRC-CV") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);
    }
}

