/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.administration.implementation.models;

import com.azure.core.util.CoreUtils;
import com.azure.messaging.servicebus.administration.implementation.models.ResponseAuthor;
import com.azure.messaging.servicebus.administration.implementation.models.ResponseLink;
import com.azure.messaging.servicebus.administration.implementation.models.Title;
import com.azure.messaging.servicebus.administration.implementation.models.TopicDescriptionEntryContent;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class TopicDescriptionEntry
implements XmlSerializable<TopicDescriptionEntry> {
    private static final String WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM = "http://www.w3.org/2005/Atom";
    private String base;
    private String id;
    private Title title;
    private OffsetDateTime published;
    private OffsetDateTime updated;
    private ResponseAuthor author;
    private ResponseLink link;
    private TopicDescriptionEntryContent content;

    public String getBase() {
        return this.base;
    }

    public TopicDescriptionEntry setBase(String base) {
        this.base = base;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public TopicDescriptionEntry setId(String id) {
        this.id = id;
        return this;
    }

    public Title getTitle() {
        return this.title;
    }

    public TopicDescriptionEntry setTitle(Title title) {
        this.title = title;
        return this;
    }

    public OffsetDateTime getPublished() {
        return this.published;
    }

    public TopicDescriptionEntry setPublished(OffsetDateTime published) {
        this.published = published;
        return this;
    }

    public OffsetDateTime getUpdated() {
        return this.updated;
    }

    public TopicDescriptionEntry setUpdated(OffsetDateTime updated) {
        this.updated = updated;
        return this;
    }

    public ResponseAuthor getAuthor() {
        return this.author;
    }

    public TopicDescriptionEntry setAuthor(ResponseAuthor author) {
        this.author = author;
        return this;
    }

    public ResponseLink getLink() {
        return this.link;
    }

    public TopicDescriptionEntry setLink(ResponseLink link) {
        this.link = link;
        return this;
    }

    public TopicDescriptionEntryContent getContent() {
        return this.content;
    }

    public TopicDescriptionEntry setContent(TopicDescriptionEntryContent content) {
        this.content = content;
        return this;
    }

    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = rootElementName == null || rootElementName.isEmpty() ? "entry" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeNamespace(WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM);
        xmlWriter.writeStringAttribute("base", this.base);
        xmlWriter.writeStringElement(WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM, "id", this.id);
        xmlWriter.writeXml((XmlSerializable)this.title, "title");
        xmlWriter.writeStringElement(WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM, "published", this.published == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.published));
        xmlWriter.writeStringElement(WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM, "updated", this.updated == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.updated));
        xmlWriter.writeXml((XmlSerializable)this.author, "author");
        xmlWriter.writeXml((XmlSerializable)this.link, "link");
        xmlWriter.writeXml((XmlSerializable)this.content, "content");
        return xmlWriter.writeEndElement();
    }

    public static TopicDescriptionEntry fromXml(XmlReader xmlReader) throws XMLStreamException {
        return TopicDescriptionEntry.fromXml(xmlReader, null);
    }

    public static TopicDescriptionEntry fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = rootElementName == null || rootElementName.isEmpty() ? "entry" : rootElementName;
        return (TopicDescriptionEntry)xmlReader.readObject(WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM, finalRootElementName, reader -> {
            TopicDescriptionEntry deserializedTopicDescriptionEntry = new TopicDescriptionEntry();
            deserializedTopicDescriptionEntry.base = reader.getStringAttribute(null, "base");
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("id".equals(elementName.getLocalPart()) && WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM.equals(elementName.getNamespaceURI())) {
                    deserializedTopicDescriptionEntry.id = reader.getStringElement();
                    continue;
                }
                if ("title".equals(elementName.getLocalPart()) && WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM.equals(elementName.getNamespaceURI())) {
                    deserializedTopicDescriptionEntry.title = Title.fromXml(reader, "title");
                    continue;
                }
                if ("published".equals(elementName.getLocalPart()) && WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM.equals(elementName.getNamespaceURI())) {
                    deserializedTopicDescriptionEntry.published = (OffsetDateTime)reader.getNullableElement(dateString -> CoreUtils.parseBestOffsetDateTime((String)dateString));
                    continue;
                }
                if ("updated".equals(elementName.getLocalPart()) && WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM.equals(elementName.getNamespaceURI())) {
                    deserializedTopicDescriptionEntry.updated = (OffsetDateTime)reader.getNullableElement(dateString -> CoreUtils.parseBestOffsetDateTime((String)dateString));
                    continue;
                }
                if ("author".equals(elementName.getLocalPart()) && WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM.equals(elementName.getNamespaceURI())) {
                    deserializedTopicDescriptionEntry.author = ResponseAuthor.fromXml(reader, "author");
                    continue;
                }
                if ("link".equals(elementName.getLocalPart()) && WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM.equals(elementName.getNamespaceURI())) {
                    deserializedTopicDescriptionEntry.link = ResponseLink.fromXml(reader, "link");
                    continue;
                }
                if ("content".equals(elementName.getLocalPart()) && WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM.equals(elementName.getNamespaceURI())) {
                    deserializedTopicDescriptionEntry.content = TopicDescriptionEntryContent.fromXml(reader, "content");
                    continue;
                }
                reader.skipElement();
            }
            return deserializedTopicDescriptionEntry;
        });
    }
}

