/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.administration.implementation.models;

import com.azure.core.util.CoreUtils;
import com.azure.messaging.servicebus.administration.implementation.models.EntityAvailabilityStatus;
import com.azure.messaging.servicebus.administration.implementation.models.MessageCountDetails;
import com.azure.messaging.servicebus.administration.implementation.models.RuleDescription;
import com.azure.messaging.servicebus.administration.models.EntityStatus;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class SubscriptionDescription
implements XmlSerializable<SubscriptionDescription> {
    private static final String SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT = "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect";
    private Duration lockDuration;
    private Boolean requiresSession;
    private Duration defaultMessageTimeToLive;
    private Boolean deadLetteringOnMessageExpiration;
    private Boolean deadLetteringOnFilterEvaluationExceptions;
    private RuleDescription defaultRuleDescription;
    private Integer messageCount;
    private Integer maxDeliveryCount;
    private Boolean enableBatchedOperations;
    private EntityStatus status;
    private String forwardTo;
    private OffsetDateTime createdAt;
    private OffsetDateTime updatedAt;
    private OffsetDateTime accessedAt;
    private MessageCountDetails messageCountDetails;
    private String userMetadata;
    private String forwardDeadLetteredMessagesTo;
    private Duration autoDeleteOnIdle;
    private EntityAvailabilityStatus entityAvailabilityStatus;

    public Duration getLockDuration() {
        return this.lockDuration;
    }

    public SubscriptionDescription setLockDuration(Duration lockDuration) {
        this.lockDuration = lockDuration;
        return this;
    }

    public Boolean isRequiresSession() {
        return this.requiresSession;
    }

    public SubscriptionDescription setRequiresSession(Boolean requiresSession) {
        this.requiresSession = requiresSession;
        return this;
    }

    public Duration getDefaultMessageTimeToLive() {
        return this.defaultMessageTimeToLive;
    }

    public SubscriptionDescription setDefaultMessageTimeToLive(Duration defaultMessageTimeToLive) {
        this.defaultMessageTimeToLive = defaultMessageTimeToLive;
        return this;
    }

    public Boolean isDeadLetteringOnMessageExpiration() {
        return this.deadLetteringOnMessageExpiration;
    }

    public SubscriptionDescription setDeadLetteringOnMessageExpiration(Boolean deadLetteringOnMessageExpiration) {
        this.deadLetteringOnMessageExpiration = deadLetteringOnMessageExpiration;
        return this;
    }

    public Boolean isDeadLetteringOnFilterEvaluationExceptions() {
        return this.deadLetteringOnFilterEvaluationExceptions;
    }

    public SubscriptionDescription setDeadLetteringOnFilterEvaluationExceptions(Boolean deadLetteringOnFilterEvaluationExceptions) {
        this.deadLetteringOnFilterEvaluationExceptions = deadLetteringOnFilterEvaluationExceptions;
        return this;
    }

    public RuleDescription getDefaultRuleDescription() {
        return this.defaultRuleDescription;
    }

    public SubscriptionDescription setDefaultRuleDescription(RuleDescription defaultRuleDescription) {
        this.defaultRuleDescription = defaultRuleDescription;
        return this;
    }

    public Integer getMessageCount() {
        return this.messageCount;
    }

    public SubscriptionDescription setMessageCount(Integer messageCount) {
        this.messageCount = messageCount;
        return this;
    }

    public Integer getMaxDeliveryCount() {
        return this.maxDeliveryCount;
    }

    public SubscriptionDescription setMaxDeliveryCount(Integer maxDeliveryCount) {
        this.maxDeliveryCount = maxDeliveryCount;
        return this;
    }

    public Boolean isEnableBatchedOperations() {
        return this.enableBatchedOperations;
    }

    public SubscriptionDescription setEnableBatchedOperations(Boolean enableBatchedOperations) {
        this.enableBatchedOperations = enableBatchedOperations;
        return this;
    }

    public EntityStatus getStatus() {
        return this.status;
    }

    public SubscriptionDescription setStatus(EntityStatus status) {
        this.status = status;
        return this;
    }

    public String getForwardTo() {
        return this.forwardTo;
    }

    public SubscriptionDescription setForwardTo(String forwardTo) {
        this.forwardTo = forwardTo;
        return this;
    }

    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public SubscriptionDescription setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public SubscriptionDescription setUpdatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    public OffsetDateTime getAccessedAt() {
        return this.accessedAt;
    }

    public SubscriptionDescription setAccessedAt(OffsetDateTime accessedAt) {
        this.accessedAt = accessedAt;
        return this;
    }

    public MessageCountDetails getMessageCountDetails() {
        return this.messageCountDetails;
    }

    public SubscriptionDescription setMessageCountDetails(MessageCountDetails messageCountDetails) {
        this.messageCountDetails = messageCountDetails;
        return this;
    }

    public String getUserMetadata() {
        return this.userMetadata;
    }

    public SubscriptionDescription setUserMetadata(String userMetadata) {
        this.userMetadata = userMetadata;
        return this;
    }

    public String getForwardDeadLetteredMessagesTo() {
        return this.forwardDeadLetteredMessagesTo;
    }

    public SubscriptionDescription setForwardDeadLetteredMessagesTo(String forwardDeadLetteredMessagesTo) {
        this.forwardDeadLetteredMessagesTo = forwardDeadLetteredMessagesTo;
        return this;
    }

    public Duration getAutoDeleteOnIdle() {
        return this.autoDeleteOnIdle;
    }

    public SubscriptionDescription setAutoDeleteOnIdle(Duration autoDeleteOnIdle) {
        this.autoDeleteOnIdle = autoDeleteOnIdle;
        return this;
    }

    public EntityAvailabilityStatus getEntityAvailabilityStatus() {
        return this.entityAvailabilityStatus;
    }

    public SubscriptionDescription setEntityAvailabilityStatus(EntityAvailabilityStatus entityAvailabilityStatus) {
        this.entityAvailabilityStatus = entityAvailabilityStatus;
        return this;
    }

    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = rootElementName == null || rootElementName.isEmpty() ? "SubscriptionDescription" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeNamespace(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT);
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "LockDuration", CoreUtils.durationToStringWithDays((Duration)this.lockDuration));
        xmlWriter.writeBooleanElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "RequiresSession", this.requiresSession);
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "DefaultMessageTimeToLive", CoreUtils.durationToStringWithDays((Duration)this.defaultMessageTimeToLive));
        xmlWriter.writeBooleanElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "DeadLetteringOnMessageExpiration", this.deadLetteringOnMessageExpiration);
        xmlWriter.writeBooleanElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "DeadLetteringOnFilterEvaluationExceptions", this.deadLetteringOnFilterEvaluationExceptions);
        xmlWriter.writeXml((XmlSerializable)this.defaultRuleDescription, "DefaultRuleDescription");
        xmlWriter.writeNumberElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "MessageCount", (Number)this.messageCount);
        xmlWriter.writeNumberElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "MaxDeliveryCount", (Number)this.maxDeliveryCount);
        xmlWriter.writeBooleanElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "EnableBatchedOperations", this.enableBatchedOperations);
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "Status", this.status == null ? null : this.status.toString());
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "ForwardTo", this.forwardTo);
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "CreatedAt", this.createdAt == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdAt));
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "UpdatedAt", this.updatedAt == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.updatedAt));
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "AccessedAt", this.accessedAt == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.accessedAt));
        xmlWriter.writeXml((XmlSerializable)this.messageCountDetails, "CountDetails");
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "UserMetadata", this.userMetadata);
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "ForwardDeadLetteredMessagesTo", this.forwardDeadLetteredMessagesTo);
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "AutoDeleteOnIdle", CoreUtils.durationToStringWithDays((Duration)this.autoDeleteOnIdle));
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "EntityAvailabilityStatus", this.entityAvailabilityStatus == null ? null : this.entityAvailabilityStatus.toString());
        return xmlWriter.writeEndElement();
    }

    public static SubscriptionDescription fromXml(XmlReader xmlReader) throws XMLStreamException {
        return SubscriptionDescription.fromXml(xmlReader, null);
    }

    public static SubscriptionDescription fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = rootElementName == null || rootElementName.isEmpty() ? "SubscriptionDescription" : rootElementName;
        return (SubscriptionDescription)xmlReader.readObject(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, finalRootElementName, reader -> {
            SubscriptionDescription deserializedSubscriptionDescription = new SubscriptionDescription();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("LockDuration".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedSubscriptionDescription.lockDuration = (Duration)reader.getNullableElement(Duration::parse);
                    continue;
                }
                if ("RequiresSession".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedSubscriptionDescription.requiresSession = (Boolean)reader.getNullableElement(Boolean::parseBoolean);
                    continue;
                }
                if ("DefaultMessageTimeToLive".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedSubscriptionDescription.defaultMessageTimeToLive = (Duration)reader.getNullableElement(Duration::parse);
                    continue;
                }
                if ("DeadLetteringOnMessageExpiration".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedSubscriptionDescription.deadLetteringOnMessageExpiration = (Boolean)reader.getNullableElement(Boolean::parseBoolean);
                    continue;
                }
                if ("DeadLetteringOnFilterEvaluationExceptions".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedSubscriptionDescription.deadLetteringOnFilterEvaluationExceptions = (Boolean)reader.getNullableElement(Boolean::parseBoolean);
                    continue;
                }
                if ("DefaultRuleDescription".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedSubscriptionDescription.defaultRuleDescription = RuleDescription.fromXml(reader, "DefaultRuleDescription");
                    continue;
                }
                if ("MessageCount".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedSubscriptionDescription.messageCount = (Integer)reader.getNullableElement(Integer::parseInt);
                    continue;
                }
                if ("MaxDeliveryCount".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedSubscriptionDescription.maxDeliveryCount = (Integer)reader.getNullableElement(Integer::parseInt);
                    continue;
                }
                if ("EnableBatchedOperations".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedSubscriptionDescription.enableBatchedOperations = (Boolean)reader.getNullableElement(Boolean::parseBoolean);
                    continue;
                }
                if ("Status".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedSubscriptionDescription.status = EntityStatus.fromString(reader.getStringElement());
                    continue;
                }
                if ("ForwardTo".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedSubscriptionDescription.forwardTo = reader.getStringElement();
                    continue;
                }
                if ("CreatedAt".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedSubscriptionDescription.createdAt = (OffsetDateTime)reader.getNullableElement(dateString -> CoreUtils.parseBestOffsetDateTime((String)dateString));
                    continue;
                }
                if ("UpdatedAt".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedSubscriptionDescription.updatedAt = (OffsetDateTime)reader.getNullableElement(dateString -> CoreUtils.parseBestOffsetDateTime((String)dateString));
                    continue;
                }
                if ("AccessedAt".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedSubscriptionDescription.accessedAt = (OffsetDateTime)reader.getNullableElement(dateString -> CoreUtils.parseBestOffsetDateTime((String)dateString));
                    continue;
                }
                if ("CountDetails".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedSubscriptionDescription.messageCountDetails = MessageCountDetails.fromXml(reader, "CountDetails");
                    continue;
                }
                if ("UserMetadata".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedSubscriptionDescription.userMetadata = reader.getStringElement();
                    continue;
                }
                if ("ForwardDeadLetteredMessagesTo".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedSubscriptionDescription.forwardDeadLetteredMessagesTo = reader.getStringElement();
                    continue;
                }
                if ("AutoDeleteOnIdle".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedSubscriptionDescription.autoDeleteOnIdle = (Duration)reader.getNullableElement(Duration::parse);
                    continue;
                }
                if ("EntityAvailabilityStatus".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedSubscriptionDescription.entityAvailabilityStatus = EntityAvailabilityStatus.fromString(reader.getStringElement());
                    continue;
                }
                reader.skipElement();
            }
            return deserializedSubscriptionDescription;
        });
    }
}

