/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus;

import com.azure.core.annotation.ServiceClient;
import com.azure.core.util.IterableStream;
import com.azure.messaging.servicebus.ServiceBusClientBuilder;
import com.azure.messaging.servicebus.ServiceBusRuleManagerAsyncClient;
import com.azure.messaging.servicebus.administration.models.CreateRuleOptions;
import com.azure.messaging.servicebus.administration.models.RuleProperties;
import java.time.Duration;
import java.util.Objects;

@ServiceClient(builder=ServiceBusClientBuilder.class)
public class ServiceBusRuleManagerClient
implements AutoCloseable {
    private final ServiceBusRuleManagerAsyncClient asyncClient;
    private final Duration operationTimeout;

    ServiceBusRuleManagerClient(ServiceBusRuleManagerAsyncClient asyncClient, Duration operationTimeout) {
        this.asyncClient = Objects.requireNonNull(asyncClient, "'asyncClient' cannot be null.");
        this.operationTimeout = Objects.requireNonNull(operationTimeout, "'operationTimeout' cannot be null.");
    }

    public String getFullyQualifiedNamespace() {
        return this.asyncClient.getFullyQualifiedNamespace();
    }

    public String getEntityPath() {
        return this.asyncClient.getEntityPath();
    }

    public void createRule(String ruleName, CreateRuleOptions options) {
        this.asyncClient.createRule(ruleName, options).block(this.operationTimeout);
    }

    public IterableStream<RuleProperties> listRules() {
        return new IterableStream(this.asyncClient.listRules());
    }

    public void deleteRule(String ruleName) {
        this.asyncClient.deleteRule(ruleName).block(this.operationTimeout);
    }

    @Override
    public void close() {
        this.asyncClient.close();
    }
}

