/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.administration.models;

import com.azure.messaging.servicebus.administration.implementation.EntityHelper;
import com.azure.messaging.servicebus.administration.implementation.models.MessageCountDetails;
import com.azure.messaging.servicebus.administration.implementation.models.QueueDescription;
import com.azure.messaging.servicebus.administration.models.AuthorizationRule;
import com.azure.messaging.servicebus.administration.models.EntityStatus;
import com.azure.messaging.servicebus.administration.models.SharedAccessAuthorizationRule;
import com.azure.messaging.servicebus.implementation.MessageUtils;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.stream.Collectors;

public final class QueueProperties {
    private final QueueDescription description;
    private final List<AuthorizationRule> authorizationRules;
    private String queueName;

    QueueProperties(QueueDescription description) {
        this.description = description;
        this.authorizationRules = description.getAuthorizationRules().stream().map(SharedAccessAuthorizationRule::new).collect(Collectors.toList());
    }

    public String getName() {
        return this.queueName;
    }

    public Duration getAutoDeleteOnIdle() {
        return this.description.getAutoDeleteOnIdle();
    }

    public QueueProperties setAutoDeleteOnIdle(Duration autoDeleteOnIdle) {
        this.description.setAutoDeleteOnIdle(autoDeleteOnIdle);
        return this;
    }

    public List<AuthorizationRule> getAuthorizationRules() {
        return this.authorizationRules;
    }

    public Duration getDefaultMessageTimeToLive() {
        return this.description.getDefaultMessageTimeToLive();
    }

    public QueueProperties setDefaultMessageTimeToLive(Duration defaultMessageTimeToLive) {
        this.description.setDefaultMessageTimeToLive(defaultMessageTimeToLive);
        return this;
    }

    public boolean isDeadLetteringOnMessageExpiration() {
        return MessageUtils.toPrimitive(this.description.isDeadLetteringOnMessageExpiration());
    }

    public QueueProperties setDeadLetteringOnMessageExpiration(boolean deadLetteringOnMessageExpiration) {
        this.description.setDeadLetteringOnMessageExpiration(deadLetteringOnMessageExpiration);
        return this;
    }

    public Duration getDuplicateDetectionHistoryTimeWindow() {
        return this.description.getDuplicateDetectionHistoryTimeWindow();
    }

    public QueueProperties setDuplicateDetectionHistoryTimeWindow(Duration duplicateDetectionHistoryTimeWindow) {
        this.description.setDuplicateDetectionHistoryTimeWindow(duplicateDetectionHistoryTimeWindow);
        return this;
    }

    public boolean isBatchedOperationsEnabled() {
        return MessageUtils.toPrimitive(this.description.isEnableBatchedOperations());
    }

    public QueueProperties setBatchedOperationsEnabled(boolean enableBatchedOperations) {
        this.description.setEnableBatchedOperations(enableBatchedOperations);
        return this;
    }

    public boolean isPartitioningEnabled() {
        return MessageUtils.toPrimitive(this.description.isEnablePartitioning());
    }

    public String getForwardTo() {
        return this.description.getForwardTo();
    }

    public QueueProperties setForwardTo(String forwardTo) {
        this.description.setForwardTo(forwardTo);
        return this;
    }

    public String getForwardDeadLetteredMessagesTo() {
        return this.description.getForwardDeadLetteredMessagesTo();
    }

    public QueueProperties setForwardDeadLetteredMessagesTo(String forwardDeadLetteredMessagesTo) {
        this.description.setForwardDeadLetteredMessagesTo(forwardDeadLetteredMessagesTo);
        return this;
    }

    public Duration getLockDuration() {
        return this.description.getLockDuration();
    }

    public QueueProperties setLockDuration(Duration lockDuration) {
        this.description.setLockDuration(lockDuration);
        return this;
    }

    public int getMaxDeliveryCount() {
        return MessageUtils.toPrimitive(this.description.getMaxDeliveryCount());
    }

    public QueueProperties setMaxDeliveryCount(Integer maxDeliveryCount) {
        this.description.setMaxDeliveryCount(maxDeliveryCount);
        return this;
    }

    public long getMaxSizeInMegabytes() {
        return MessageUtils.toPrimitive(this.description.getMaxSizeInMegabytes());
    }

    public QueueProperties setMaxSizeInMegabytes(Integer maxSizeInMegabytes) {
        this.description.setMaxSizeInMegabytes(maxSizeInMegabytes == null ? null : Long.valueOf(maxSizeInMegabytes.intValue()));
        return this;
    }

    public boolean isDuplicateDetectionRequired() {
        return MessageUtils.toPrimitive(this.description.isRequiresDuplicateDetection());
    }

    public boolean isSessionRequired() {
        return MessageUtils.toPrimitive(this.description.isRequiresSession());
    }

    public EntityStatus getStatus() {
        return this.description.getStatus();
    }

    public QueueProperties setStatus(EntityStatus status) {
        this.description.setStatus(status);
        return this;
    }

    public String getUserMetadata() {
        return this.description.getUserMetadata();
    }

    public QueueProperties setUserMetadata(String userMetadata) {
        this.description.setUserMetadata(userMetadata);
        return this;
    }

    public long getMaxMessageSizeInKilobytes() {
        return MessageUtils.toPrimitive(this.description.getMaxMessageSizeInKilobytes());
    }

    public QueueProperties setMaxMessageSizeInKilobytes(long maxMessageSizeInKilobytes) {
        this.description.setMaxMessageSizeInKilobytes(maxMessageSizeInKilobytes);
        return this;
    }

    OffsetDateTime getAccessedAt() {
        return this.description.getAccessedAt();
    }

    OffsetDateTime getCreatedAt() {
        return this.description.getCreatedAt();
    }

    Integer getMessageCount() {
        return this.description.getMessageCount();
    }

    MessageCountDetails getMessageCountDetails() {
        return this.description.getMessageCountDetails();
    }

    Long getSizeInBytes() {
        return this.description.getSizeInBytes();
    }

    OffsetDateTime getUpdatedAt() {
        return this.description.getUpdatedAt();
    }

    QueueProperties setPartitioningEnabled(boolean enablePartitioning) {
        this.description.setEnablePartitioning(enablePartitioning);
        return this;
    }

    QueueProperties setDuplicateDetectionRequired(boolean requiresDuplicateDetection) {
        this.description.setRequiresDuplicateDetection(requiresDuplicateDetection);
        return this;
    }

    QueueProperties setSessionRequired(boolean requiresSession) {
        this.description.setRequiresSession(requiresSession);
        return this;
    }

    static {
        EntityHelper.setQueueAccessor(new EntityHelper.QueueAccessor(){

            @Override
            public QueueDescription toImplementation(QueueProperties queue, List<com.azure.messaging.servicebus.administration.implementation.models.AuthorizationRule> rules) {
                QueueDescription description = new QueueDescription().setAccessedAt(queue.getAccessedAt()).setAutoDeleteOnIdle(queue.getAutoDeleteOnIdle()).setCreatedAt(queue.getCreatedAt()).setDeadLetteringOnMessageExpiration(queue.isDeadLetteringOnMessageExpiration()).setDefaultMessageTimeToLive(queue.getDefaultMessageTimeToLive()).setDuplicateDetectionHistoryTimeWindow(queue.getDuplicateDetectionHistoryTimeWindow()).setEnablePartitioning(queue.isPartitioningEnabled()).setEnableExpress(queue.description.isEnableExpress()).setEnableBatchedOperations(queue.description.isEnableBatchedOperations()).setEntityAvailabilityStatus(queue.description.getEntityAvailabilityStatus()).setForwardTo(queue.getForwardTo()).setForwardDeadLetteredMessagesTo(queue.getForwardDeadLetteredMessagesTo()).setIsAnonymousAccessible(queue.description.isAnonymousAccessible()).setLockDuration(queue.getLockDuration()).setMaxSizeInMegabytes(queue.getMaxSizeInMegabytes()).setMaxDeliveryCount(queue.getMaxDeliveryCount()).setMessageCount(queue.description.getMessageCount()).setMessageCountDetails(queue.getMessageCountDetails()).setSupportOrdering(queue.description.isSupportOrdering()).setStatus(queue.getStatus()).setSizeInBytes(queue.getSizeInBytes()).setRequiresSession(queue.isSessionRequired()).setRequiresDuplicateDetection(queue.isDuplicateDetectionRequired()).setUpdatedAt(queue.getUpdatedAt()).setUserMetadata(queue.getUserMetadata());
                if (!rules.isEmpty()) {
                    description.setAuthorizationRules(rules);
                }
                if (queue.getMaxMessageSizeInKilobytes() != 0L) {
                    description.setMaxMessageSizeInKilobytes(queue.getMaxMessageSizeInKilobytes());
                }
                return description;
            }

            @Override
            public QueueProperties toModel(QueueDescription queueDescription) {
                return new QueueProperties(queueDescription);
            }

            @Override
            public void setName(QueueProperties queueProperties, String name) {
                queueProperties.queueName = name;
            }
        });
    }
}

