/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.query;

import com.azure.cosmos.CosmosItemSerializer;
import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.JsonSerializable;
import com.azure.cosmos.implementation.ObjectNodeMap;
import com.azure.cosmos.implementation.Utils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Map;

public final class ValueUnwrapCosmosItemSerializer
extends CosmosItemSerializer {
    private static ValueUnwrapCosmosItemSerializer EnableUnwrapSingletonInstance = new ValueUnwrapCosmosItemSerializer(true);
    private static ValueUnwrapCosmosItemSerializer DisableUnwrapSingletonInstance = new ValueUnwrapCosmosItemSerializer(false);
    private final boolean shouldUnwrapValue;

    public static CosmosItemSerializer create(boolean shouldUnwrapValue) {
        if (shouldUnwrapValue) {
            return EnableUnwrapSingletonInstance;
        }
        return DisableUnwrapSingletonInstance;
    }

    private ValueUnwrapCosmosItemSerializer(boolean shouldUnwrapValue) {
        ImplementationBridgeHelpers.CosmosItemSerializerHelper.getCosmosItemSerializerAccessor().setShouldWrapSerializationExceptions(this, false);
        this.shouldUnwrapValue = shouldUnwrapValue;
    }

    @Override
    public <T> Map<String, Object> serialize(T item) {
        throw new IllegalStateException("Method 'serialize' is not implemented for this serializer");
    }

    @Override
    public <T> T deserialize(Map<String, Object> jsonNodeMap, Class<T> classType) {
        if (jsonNodeMap == null) {
            return null;
        }
        ObjectNode jsonNode = jsonNodeMap instanceof ObjectNodeMap ? ((ObjectNodeMap)jsonNodeMap).getObjectNode() : (ObjectNode)Utils.getSimpleObjectMapper().convertValue(jsonNodeMap, ObjectNode.class);
        return JsonSerializable.toObjectFromObjectNode((JsonNode)jsonNode, this.shouldUnwrapValue, classType);
    }
}

