/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.directconnectivity.rntbd;

import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdEndpoint;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class RntbdDurableEndpointMetrics {
    private final AtomicInteger totalAcquiredChannels = new AtomicInteger(0);
    private final AtomicInteger totalClosedChannels = new AtomicInteger(0);
    private final AtomicReference<RntbdEndpoint> latestEndpoint = new AtomicReference();

    public RntbdEndpoint getEndpoint() {
        return this.latestEndpoint.get();
    }

    public void setEndpoint(RntbdEndpoint endpoint) {
        this.latestEndpoint.set(endpoint);
    }

    public void clearEndpoint(RntbdEndpoint endpoint) {
        this.latestEndpoint.compareAndSet(endpoint, null);
    }

    public void incrementAcquiredChannels() {
        this.totalAcquiredChannels.incrementAndGet();
    }

    public void incrementClosedChannels() {
        this.totalClosedChannels.incrementAndGet();
    }

    public int channelsAvailableMetric() {
        RntbdEndpoint snapshot = this.latestEndpoint.get();
        if (snapshot != null) {
            return snapshot.channelsAvailableMetric();
        }
        return 0;
    }

    public int totalChannelsClosedMetric() {
        return this.totalClosedChannels.get();
    }

    public int totalChannelsAcquiredMetric() {
        return this.totalAcquiredChannels.get();
    }
}

