/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.batch;

import com.azure.cosmos.implementation.JsonSerializable;
import com.azure.cosmos.implementation.RxDocumentServiceResponse;
import com.azure.cosmos.implementation.batch.BatchExecUtils;
import com.azure.cosmos.implementation.batch.ServerBatchRequest;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.models.CosmosBatchOperationResult;
import com.azure.cosmos.models.CosmosBatchResponse;
import com.azure.cosmos.models.CosmosItemOperation;
import com.azure.cosmos.models.ModelBridgeInternal;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;

public final class BatchResponseParser {
    public static CosmosBatchResponse fromDocumentServiceResponse(RxDocumentServiceResponse documentServiceResponse, ServerBatchRequest request, boolean shouldPromoteOperationStatus) {
        CosmosBatchResponse response = null;
        JsonNode responseContentAsJson = documentServiceResponse.getResponseBody();
        if (responseContentAsJson != null && (response = BatchResponseParser.populateFromResponseContent(documentServiceResponse, request, shouldPromoteOperationStatus)) == null) {
            response = ModelBridgeInternal.createCosmosBatchResponse(HttpResponseStatus.INTERNAL_SERVER_ERROR.code(), 0, "ServerResponseDeserializationFailure", documentServiceResponse.getResponseHeaders(), documentServiceResponse.getCosmosDiagnostics());
        }
        int responseStatusCode = documentServiceResponse.getStatusCode();
        int responseSubStatusCode = BatchExecUtils.getSubStatusCode(documentServiceResponse.getResponseHeaders());
        if (response == null) {
            response = ModelBridgeInternal.createCosmosBatchResponse(responseStatusCode, responseSubStatusCode, null, documentServiceResponse.getResponseHeaders(), documentServiceResponse.getCosmosDiagnostics());
        }
        if (response.size() != request.getOperations().size()) {
            if (responseStatusCode >= 200 && responseStatusCode <= 299) {
                response = ModelBridgeInternal.createCosmosBatchResponse(HttpResponseStatus.INTERNAL_SERVER_ERROR.code(), 0, "Invalid server response", documentServiceResponse.getResponseHeaders(), documentServiceResponse.getCosmosDiagnostics());
            }
            Duration retryAfterDuration = Duration.ZERO;
            if (responseStatusCode == HttpResponseStatus.TOO_MANY_REQUESTS.code()) {
                retryAfterDuration = BatchExecUtils.getRetryAfterDuration(documentServiceResponse.getResponseHeaders());
            }
            BatchResponseParser.createAndPopulateResults(response, request.getOperations(), retryAfterDuration);
        }
        Preconditions.checkState(response.size() == request.getOperations().size(), "Number of responses should be equal to number of operations in request.");
        return response;
    }

    private static CosmosBatchResponse populateFromResponseContent(RxDocumentServiceResponse documentServiceResponse, ServerBatchRequest request, boolean shouldPromoteOperationStatus) {
        ArrayList<CosmosBatchOperationResult> results = new ArrayList<CosmosBatchOperationResult>(request.getOperations().size());
        ArrayNode responseContent = (ArrayNode)documentServiceResponse.getResponseBody();
        List<CosmosItemOperation> cosmosItemOperations = request.getOperations();
        ObjectNode[] objectNodes = new ObjectNode[responseContent.size()];
        int i = 0;
        for (JsonNode arrayItemNode : responseContent) {
            objectNodes[i] = (ObjectNode)arrayItemNode;
            ++i;
        }
        for (int index = 0; index < objectNodes.length; ++index) {
            ObjectNode objectInArray = objectNodes[index];
            results.add(BatchResponseParser.createBatchOperationResultFromJson(objectInArray, cosmosItemOperations.get(index)));
        }
        int responseStatusCode = documentServiceResponse.getStatusCode();
        int responseSubStatusCode = BatchExecUtils.getSubStatusCode(documentServiceResponse.getResponseHeaders());
        if (responseStatusCode == HttpResponseStatus.MULTI_STATUS.code() && shouldPromoteOperationStatus) {
            for (CosmosBatchOperationResult result : results) {
                if (result.getStatusCode() == HttpResponseStatus.FAILED_DEPENDENCY.code() || result.getStatusCode() < 400) continue;
                responseStatusCode = result.getStatusCode();
                responseSubStatusCode = result.getSubStatusCode();
                break;
            }
        }
        CosmosBatchResponse response = ModelBridgeInternal.createCosmosBatchResponse(responseStatusCode, responseSubStatusCode, null, documentServiceResponse.getResponseHeaders(), documentServiceResponse.getCosmosDiagnostics());
        ModelBridgeInternal.addCosmosBatchResultInResponse(response, results);
        assert (response.getResults().size() == request.getOperations().size());
        return response;
    }

    private static CosmosBatchOperationResult createBatchOperationResultFromJson(ObjectNode objectNode, CosmosItemOperation cosmosItemOperation) {
        Double requestCharge;
        JsonSerializable jsonSerializable = new JsonSerializable(objectNode);
        int statusCode = jsonSerializable.getInt("statusCode");
        Integer subStatusCode = jsonSerializable.getInt("subStatusCode");
        if (subStatusCode == null) {
            subStatusCode = 0;
        }
        if ((requestCharge = jsonSerializable.getDouble("requestCharge")) == null) {
            requestCharge = 0.0;
        }
        String eTag = jsonSerializable.getString("eTag");
        ObjectNode resourceBody = jsonSerializable.getObject("resourceBody");
        Integer retryAfterMilliseconds = jsonSerializable.getInt("retryAfterMilliseconds");
        return ModelBridgeInternal.createCosmosBatchResult(eTag, requestCharge, resourceBody, statusCode, retryAfterMilliseconds != null ? Duration.ofMillis(retryAfterMilliseconds.intValue()) : Duration.ZERO, subStatusCode, cosmosItemOperation);
    }

    private static void createAndPopulateResults(CosmosBatchResponse response, List<CosmosItemOperation> operations, Duration retryAfterDuration) {
        ArrayList<CosmosBatchOperationResult> results = new ArrayList<CosmosBatchOperationResult>(operations.size());
        for (CosmosItemOperation cosmosItemOperation : operations) {
            results.add(ModelBridgeInternal.createCosmosBatchResult(null, response.getRequestCharge(), null, response.getStatusCode(), retryAfterDuration, response.getSubStatusCode(), cosmosItemOperation));
        }
        ModelBridgeInternal.addCosmosBatchResultInResponse(response, results);
    }
}

