/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.implementation.feedranges.FeedRangeEpkImpl;
import com.azure.cosmos.implementation.feedranges.FeedRangeInternal;
import com.azure.cosmos.implementation.feedranges.FeedRangePartitionKeyImpl;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.models.ModelBridgeInternal;
import com.azure.cosmos.models.PartitionKey;
import com.azure.cosmos.util.Beta;

@Beta(value=Beta.SinceVersion.V4_9_0, warningText="Preview API - subject to change in non-backwards compatible way")
public interface FeedRange {
    @Beta(value=Beta.SinceVersion.V4_9_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public static FeedRange fromString(String json) {
        return FeedRangeInternal.fromBase64EncodedJsonString(json);
    }

    @Beta(value=Beta.SinceVersion.V4_9_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public String toString();

    @Beta(value=Beta.SinceVersion.V4_12_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public static FeedRange forLogicalPartition(PartitionKey partitionKey) {
        Preconditions.checkNotNull(partitionKey, "Argument 'partitionKey' must not be null.");
        return new FeedRangePartitionKeyImpl(ModelBridgeInternal.getPartitionKeyInternal(partitionKey));
    }

    @Beta(value=Beta.SinceVersion.V4_12_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public static FeedRange forFullRange() {
        return FeedRangeEpkImpl.forFullRange();
    }
}

