/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.throughputControl.config;

import com.azure.cosmos.CosmosAsyncContainer;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import java.util.Objects;

public abstract class ThroughputControlGroupInternal {
    private final String groupName;
    private final String idPrefix;
    private final String id;
    private final boolean isDefault;
    private final boolean continueOnInitError;
    private final CosmosAsyncContainer targetContainer;
    private final Integer targetThroughput;
    private final Double targetThroughputThreshold;

    public ThroughputControlGroupInternal(String groupName, CosmosAsyncContainer targetContainer, Integer targetThroughput, Double targetThroughputThreshold, boolean isDefault, boolean continueOnInitError) {
        Preconditions.checkArgument(StringUtils.isNotEmpty(groupName), "Group name can not be null or empty");
        Preconditions.checkNotNull(targetContainer, "Target container can not be null");
        Preconditions.checkArgument(targetThroughput == null || targetThroughput > 0, "Target throughput should be greater than 0");
        Preconditions.checkArgument(targetThroughputThreshold == null || targetThroughputThreshold > 0.0 && targetThroughputThreshold <= 1.0, "Target throughput threshold should between (0, 1]");
        this.groupName = groupName;
        this.targetContainer = targetContainer;
        this.targetThroughput = targetThroughput;
        this.targetThroughputThreshold = targetThroughputThreshold;
        this.isDefault = isDefault;
        this.continueOnInitError = continueOnInitError;
        this.idPrefix = String.format("%s/%s/%s", this.targetContainer.getDatabase().getId(), this.targetContainer.getId(), this.groupName);
        this.id = String.format("%s/%s", this.idPrefix, ThroughputControlGroupInternal.getThroughputIdSuffix(targetThroughput, targetThroughputThreshold));
    }

    public static String getThroughputIdSuffix(Integer throughput, Double throughputThreshold) {
        StringBuilder sb = new StringBuilder();
        if (throughput != null) {
            sb.append("t-");
            sb.append(throughput);
            if (throughputThreshold == null) {
                return sb.toString();
            }
            sb.append("_");
        }
        if (throughputThreshold != null) {
            sb.append("tt-");
            sb.append(throughputThreshold);
        }
        return sb.toString();
    }

    public String getGroupName() {
        return this.groupName;
    }

    public CosmosAsyncContainer getTargetContainer() {
        return this.targetContainer;
    }

    public Integer getTargetThroughput() {
        return this.targetThroughput;
    }

    public Double getTargetThroughputThreshold() {
        return this.targetThroughputThreshold;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public boolean isContinueOnInitError() {
        return this.continueOnInitError;
    }

    public String getIdPrefix() {
        return this.idPrefix;
    }

    public String getId() {
        return this.id;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ThroughputControlGroupInternal that = (ThroughputControlGroupInternal)other;
        return Objects.equals(this.id, that.id) && this.isDefault == that.isDefault && this.continueOnInitError == that.continueOnInitError && Objects.equals(this.targetThroughput, that.targetThroughput) && Objects.equals(this.targetThroughputThreshold, that.targetThroughputThreshold);
    }

    public boolean hasSameIdentity(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ThroughputControlGroupInternal that = (ThroughputControlGroupInternal)other;
        return Objects.equals(this.idPrefix, that.idPrefix) && this.isDefault == that.isDefault && this.continueOnInitError == that.continueOnInitError;
    }

    public int hashCode() {
        int hash = 0;
        hash = hash * 397 ^ this.id.hashCode();
        hash = hash * 397 ^ Boolean.hashCode(this.isDefault);
        hash = hash * 397 ^ Boolean.hashCode(this.continueOnInitError);
        hash = hash * 397 ^ (this.targetThroughput == null ? 0 : Integer.hashCode(this.targetThroughput));
        hash = hash * 397 ^ (this.targetThroughputThreshold == null ? 0 : Double.hashCode(this.targetThroughputThreshold));
        return hash;
    }
}

