/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.routing;

import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.implementation.guava27.Strings;
import java.net.URI;

public class LocationHelper {
    public static URI getLocationEndpoint(URI serviceEndpoint, String location) {
        String host;
        CharSequence[] hostParts = StringUtils.split(serviceEndpoint.getHost(), ".", 2);
        if (hostParts.length != 0) {
            hostParts[0] = hostParts[0] + "-" + LocationHelper.dataCenterToUriPostfix(location);
            host = String.join((CharSequence)".", hostParts);
        } else {
            host = serviceEndpoint.getHost();
        }
        try {
            return new URI(serviceEndpoint.getScheme(), serviceEndpoint.getUserInfo(), host, serviceEndpoint.getPort(), serviceEndpoint.getPath(), serviceEndpoint.getQuery(), serviceEndpoint.getFragment());
        }
        catch (Exception e) {
            throw new RuntimeException(Strings.lenientFormat("invalid location [%s] or serviceEndpoint [%s]", location, serviceEndpoint.toString()), e);
        }
    }

    private static String dataCenterToUriPostfix(String dataCenter) {
        return dataCenter.replace(" ", "");
    }
}

