/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.routing;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;

public class CaseInsensitiveHashMap<V>
extends HashMap<String, V> {
    private static final long serialVersionUID = -3187010666577892790L;

    private static String safeToLower(String key) {
        return key != null ? key.toLowerCase(Locale.ROOT) : null;
    }

    @Override
    public V get(Object key) {
        return super.get(CaseInsensitiveHashMap.safeToLower((String)key));
    }

    @Override
    public void putAll(Map<? extends String, ? extends V> m) {
        super.putAll(m);
    }

    @Override
    public V put(String key, V value) {
        return super.put(CaseInsensitiveHashMap.safeToLower(key), value);
    }

    @Override
    public V putIfAbsent(String key, V value) {
        return super.putIfAbsent(CaseInsensitiveHashMap.safeToLower(key), value);
    }

    @Override
    public V compute(String key, BiFunction<? super String, ? super V, ? extends V> remappingFunction) {
        return super.compute(CaseInsensitiveHashMap.safeToLower(key), remappingFunction);
    }

    @Override
    public V computeIfAbsent(String key, Function<? super String, ? extends V> mappingFunction) {
        return super.computeIfAbsent(CaseInsensitiveHashMap.safeToLower(key), mappingFunction);
    }

    @Override
    public V computeIfPresent(String key, BiFunction<? super String, ? super V, ? extends V> remappingFunction) {
        return super.computeIfPresent(CaseInsensitiveHashMap.safeToLower(key), remappingFunction);
    }

    @Override
    public boolean containsKey(Object key) {
        return super.containsKey(CaseInsensitiveHashMap.safeToLower((String)key));
    }
}

