/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.query;

import com.azure.cosmos.implementation.DiagnosticsClientContext;
import com.azure.cosmos.implementation.PartitionKeyRange;
import com.azure.cosmos.implementation.ResourceType;
import com.azure.cosmos.implementation.query.DocumentQueryExecutionContextBase;
import com.azure.cosmos.implementation.query.IDocumentQueryClient;
import com.azure.cosmos.implementation.query.IDocumentQueryExecutionComponent;
import com.azure.cosmos.implementation.query.ParallelDocumentQueryExecutionContext;
import com.azure.cosmos.implementation.query.PipelinedDocumentQueryParams;
import com.azure.cosmos.implementation.query.PipelinedQueryExecutionContextBase;
import com.azure.cosmos.implementation.query.QueryInfo;
import com.azure.cosmos.models.CosmosQueryRequestOptions;
import com.azure.cosmos.models.FeedResponse;
import com.azure.cosmos.models.ModelBridgeInternal;
import com.azure.cosmos.models.SqlQuerySpec;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import reactor.core.publisher.Flux;

public final class PipelinedQueryExecutionContext<T>
extends PipelinedQueryExecutionContextBase<T> {
    private final IDocumentQueryExecutionComponent<T> component;

    private PipelinedQueryExecutionContext(IDocumentQueryExecutionComponent<T> component, int actualPageSize, QueryInfo queryInfo, Function<JsonNode, T> factoryMethod) {
        super(actualPageSize, queryInfo, factoryMethod);
        this.component = component;
    }

    private static <T> BiFunction<String, PipelinedDocumentQueryParams<T>, Flux<IDocumentQueryExecutionComponent<T>>> createBaseComponentFunction(DiagnosticsClientContext diagnosticsClientContext, IDocumentQueryClient client, PipelinedDocumentQueryParams<T> initParams) {
        CosmosQueryRequestOptions requestOptions = initParams.getCosmosQueryRequestOptions();
        return (continuationToken, documentQueryParams) -> {
            CosmosQueryRequestOptions parallelCosmosQueryRequestOptions = ModelBridgeInternal.createQueryRequestOptions(requestOptions);
            ModelBridgeInternal.setQueryRequestOptionsContinuationToken(parallelCosmosQueryRequestOptions, continuationToken);
            initParams.setCosmosQueryRequestOptions(parallelCosmosQueryRequestOptions);
            return ParallelDocumentQueryExecutionContext.createAsync(diagnosticsClientContext, client, documentQueryParams);
        };
    }

    private static <T> BiFunction<String, PipelinedDocumentQueryParams<T>, Flux<IDocumentQueryExecutionComponent<T>>> createPipelineComponentFunction(DiagnosticsClientContext diagnosticsClientContext, IDocumentQueryClient client, PipelinedDocumentQueryParams<T> initParams) {
        QueryInfo queryInfo = PipelinedQueryExecutionContext.validateQueryInfo(initParams.getQueryInfo());
        BiFunction<String, PipelinedDocumentQueryParams<T>, Flux<IDocumentQueryExecutionComponent<T>>> createBaseComponentFunction = PipelinedQueryExecutionContext.createBaseComponentFunction(diagnosticsClientContext, client, initParams);
        return PipelinedQueryExecutionContext.createCommonPipelineComponentFunction(createBaseComponentFunction, queryInfo);
    }

    protected static <T> Flux<PipelinedQueryExecutionContextBase<T>> createAsyncCore(DiagnosticsClientContext diagnosticsClientContext, IDocumentQueryClient client, PipelinedDocumentQueryParams<T> initParams, int pageSize, Function<JsonNode, T> factoryMethod) {
        BiFunction<String, PipelinedDocumentQueryParams<String>, Flux<IDocumentQueryExecutionComponent<String>>> createPipelineComponentFunction = PipelinedQueryExecutionContext.createPipelineComponentFunction(diagnosticsClientContext, client, initParams);
        QueryInfo queryInfo = PipelinedQueryExecutionContext.validateQueryInfo(initParams.getQueryInfo());
        CosmosQueryRequestOptions cosmosQueryRequestOptions = initParams.getCosmosQueryRequestOptions();
        return createPipelineComponentFunction.apply(ModelBridgeInternal.getRequestContinuationFromQueryRequestOptions(cosmosQueryRequestOptions), initParams).map(c -> new PipelinedQueryExecutionContext(c, pageSize, queryInfo, factoryMethod));
    }

    public static <T> Flux<PipelinedQueryExecutionContextBase<T>> createReadManyAsync(DiagnosticsClientContext diagnosticsClientContext, IDocumentQueryClient queryClient, SqlQuerySpec sqlQuery, Map<PartitionKeyRange, SqlQuerySpec> rangeQueryMap, CosmosQueryRequestOptions cosmosQueryRequestOptions, String resourceId, String collectionLink, UUID activityId, Class<T> klass, ResourceType resourceTypeEnum) {
        Flux<IDocumentQueryExecutionComponent<T>> documentQueryExecutionComponentFlux = ParallelDocumentQueryExecutionContext.createReadManyQueryAsync(diagnosticsClientContext, queryClient, sqlQuery, rangeQueryMap, cosmosQueryRequestOptions, resourceId, collectionLink, activityId, klass, resourceTypeEnum);
        Function factoryMethod = DocumentQueryExecutionContextBase.getEffectiveFactoryMethod(cosmosQueryRequestOptions, false, klass);
        return documentQueryExecutionComponentFlux.map(c -> new PipelinedQueryExecutionContext(c, -1, null, factoryMethod));
    }

    @Override
    public Flux<FeedResponse<T>> executeAsync() {
        return this.component.drainAsync(this.actualPageSize);
    }

    private static QueryInfo validateQueryInfo(QueryInfo queryInfo) {
        if (queryInfo.hasOrderBy() || queryInfo.hasAggregates() || queryInfo.hasGroupBy()) {
            throw new IllegalStateException("This query must not use the simple query pipeline.");
        }
        return queryInfo;
    }
}

