/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.query;

import com.azure.cosmos.implementation.DiagnosticsClientContext;
import com.azure.cosmos.implementation.Document;
import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.query.AggregateDocumentQueryExecutionContext;
import com.azure.cosmos.implementation.query.DCountDocumentQueryExecutionContext;
import com.azure.cosmos.implementation.query.DistinctDocumentQueryExecutionContext;
import com.azure.cosmos.implementation.query.GroupByDocumentQueryExecutionContext;
import com.azure.cosmos.implementation.query.IDocumentQueryClient;
import com.azure.cosmos.implementation.query.IDocumentQueryExecutionComponent;
import com.azure.cosmos.implementation.query.OrderByDocumentQueryExecutionContext;
import com.azure.cosmos.implementation.query.ParallelDocumentQueryExecutionContext;
import com.azure.cosmos.implementation.query.PipelinedDocumentQueryParams;
import com.azure.cosmos.implementation.query.PipelinedQueryExecutionContextBase;
import com.azure.cosmos.implementation.query.QueryInfo;
import com.azure.cosmos.models.CosmosQueryRequestOptions;
import com.azure.cosmos.models.FeedResponse;
import com.azure.cosmos.models.ModelBridgeInternal;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.function.BiFunction;
import java.util.function.Function;
import reactor.core.publisher.Flux;

public class PipelinedDocumentQueryExecutionContext<T>
extends PipelinedQueryExecutionContextBase<T> {
    private final IDocumentQueryExecutionComponent<Document> component;

    private PipelinedDocumentQueryExecutionContext(IDocumentQueryExecutionComponent<Document> pipelinedComponent, int actualPageSize, QueryInfo queryInfo, Function<JsonNode, T> factoryMethod) {
        super(actualPageSize, queryInfo, factoryMethod);
        this.component = pipelinedComponent;
    }

    private static BiFunction<String, PipelinedDocumentQueryParams<Document>, Flux<IDocumentQueryExecutionComponent<Document>>> createBaseComponentFunction(DiagnosticsClientContext diagnosticsClientContext, IDocumentQueryClient client, PipelinedDocumentQueryParams<Document> initParams) {
        QueryInfo queryInfo = initParams.getQueryInfo();
        CosmosQueryRequestOptions requestOptions = initParams.getCosmosQueryRequestOptions();
        BiFunction<String, PipelinedDocumentQueryParams<Document>, Object> createBaseComponentFunction = queryInfo.hasOrderBy() ? (continuationToken, documentQueryParams) -> {
            CosmosQueryRequestOptions orderByCosmosQueryRequestOptions = ModelBridgeInternal.createQueryRequestOptions(requestOptions);
            ModelBridgeInternal.setQueryRequestOptionsContinuationToken(orderByCosmosQueryRequestOptions, continuationToken);
            ImplementationBridgeHelpers.CosmosQueryRequestOptionsHelper.getCosmosQueryRequestOptionsAccessor().setItemFactoryMethod(orderByCosmosQueryRequestOptions, null);
            documentQueryParams.setCosmosQueryRequestOptions(orderByCosmosQueryRequestOptions);
            return OrderByDocumentQueryExecutionContext.createAsync(diagnosticsClientContext, client, documentQueryParams);
        } : (continuationToken, documentQueryParams) -> {
            CosmosQueryRequestOptions parallelCosmosQueryRequestOptions = ModelBridgeInternal.createQueryRequestOptions(requestOptions);
            ImplementationBridgeHelpers.CosmosQueryRequestOptionsHelper.getCosmosQueryRequestOptionsAccessor().setItemFactoryMethod(parallelCosmosQueryRequestOptions, null);
            ModelBridgeInternal.setQueryRequestOptionsContinuationToken(parallelCosmosQueryRequestOptions, continuationToken);
            documentQueryParams.setCosmosQueryRequestOptions(parallelCosmosQueryRequestOptions);
            return ParallelDocumentQueryExecutionContext.createAsync(diagnosticsClientContext, client, documentQueryParams);
        };
        BiFunction<String, PipelinedDocumentQueryParams<Document>, Object> createAggregateComponentFunction = queryInfo.hasAggregates() && !queryInfo.hasGroupBy() ? (continuationToken, documentQueryParams) -> AggregateDocumentQueryExecutionContext.createAsync(createBaseComponentFunction, queryInfo.getAggregates(), queryInfo.getGroupByAliasToAggregateType(), queryInfo.getGroupByAliases(), queryInfo.hasSelectValue(), continuationToken, documentQueryParams) : createBaseComponentFunction;
        return createAggregateComponentFunction;
    }

    private static BiFunction<String, PipelinedDocumentQueryParams<Document>, Flux<IDocumentQueryExecutionComponent<Document>>> createDistinctPipelineComponentFunction(BiFunction<String, PipelinedDocumentQueryParams<Document>, Flux<IDocumentQueryExecutionComponent<Document>>> createBaseComponent, QueryInfo queryInfo) {
        if (queryInfo.hasDistinct()) {
            return (continuationToken, documentQueryParams) -> DistinctDocumentQueryExecutionContext.createAsync(createBaseComponent, queryInfo.getDistinctQueryType(), continuationToken, documentQueryParams);
        }
        return createBaseComponent;
    }

    private static BiFunction<String, PipelinedDocumentQueryParams<Document>, Flux<IDocumentQueryExecutionComponent<Document>>> createPipelineComponentFunction(DiagnosticsClientContext diagnosticsClientContext, IDocumentQueryClient client, PipelinedDocumentQueryParams<Document> initParams) {
        BiFunction<String, PipelinedDocumentQueryParams<Document>, Flux<IDocumentQueryExecutionComponent<Document>>> createBaseComponentFunction = PipelinedDocumentQueryExecutionContext.createBaseComponentFunction(diagnosticsClientContext, client, initParams);
        QueryInfo queryInfo = initParams.getQueryInfo();
        BiFunction createDistinctComponentFunction = PipelinedDocumentQueryExecutionContext.createDistinctPipelineComponentFunction(createBaseComponentFunction, queryInfo);
        BiFunction createGroupByComponentFunction = queryInfo.hasGroupBy() ? (continuationToken, documentQueryParams) -> GroupByDocumentQueryExecutionContext.createAsync(createDistinctComponentFunction, continuationToken, queryInfo.getGroupByAliasToAggregateType(), queryInfo.getGroupByAliases(), queryInfo.hasSelectValue(), documentQueryParams) : createDistinctComponentFunction;
        BiFunction<String, PipelinedDocumentQueryParams<Document>, Flux<IDocumentQueryExecutionComponent<Document>>> commonPipeLineComponent = PipelinedDocumentQueryExecutionContext.createCommonPipelineComponentFunction(createGroupByComponentFunction, queryInfo);
        if (queryInfo.hasDCount()) {
            return (continuationToken, documentQueryParams) -> DCountDocumentQueryExecutionContext.createAsync(commonPipeLineComponent, queryInfo, continuationToken, documentQueryParams);
        }
        return commonPipeLineComponent;
    }

    protected static <T> Flux<PipelinedQueryExecutionContextBase<T>> createAsyncCore(DiagnosticsClientContext diagnosticsClientContext, IDocumentQueryClient client, PipelinedDocumentQueryParams<T> initParams, int pageSize, Function<JsonNode, T> factoryMethod) {
        BiFunction<String, PipelinedDocumentQueryParams<Document>, Flux<IDocumentQueryExecutionComponent<Document>>> createPipelineComponentFunction = PipelinedDocumentQueryExecutionContext.createPipelineComponentFunction(diagnosticsClientContext, client, initParams.convertGenericType(Document.class));
        QueryInfo queryInfo = initParams.getQueryInfo();
        CosmosQueryRequestOptions cosmosQueryRequestOptions = initParams.getCosmosQueryRequestOptions();
        return createPipelineComponentFunction.apply(ModelBridgeInternal.getRequestContinuationFromQueryRequestOptions(cosmosQueryRequestOptions), initParams.convertGenericType(Document.class)).map(c -> new PipelinedDocumentQueryExecutionContext((IDocumentQueryExecutionComponent<Document>)c, pageSize, queryInfo, factoryMethod));
    }

    @Override
    public Flux<FeedResponse<T>> executeAsync() {
        return this.component.drainAsync(this.actualPageSize).map(documentFeedResponse -> ImplementationBridgeHelpers.FeedResponseHelper.getFeedResponseAccessor().convertGenericType(documentFeedResponse, document -> this.factoryMethod.apply(document.getPropertyBag())));
    }
}

