/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.directconnectivity.rntbd;

import com.azure.cosmos.implementation.apachecommons.lang.tuple.Pair;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.io.Serializable;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonSerialize(using=RntbdConnectionStateListenerMetricsJsonSerializer.class)
public final class RntbdConnectionStateListenerMetrics
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(RntbdConnectionStateListenerMetrics.class);
    private final AtomicReference<Instant> lastCallTimestamp = new AtomicReference();
    private final AtomicReference<Pair<Instant, Integer>> lastActionableContext = new AtomicReference();

    public void recordAddressUpdated(int addressEntryUpdatedCount) {
        this.lastActionableContext.set(Pair.of(this.lastCallTimestamp.get(), addressEntryUpdatedCount));
    }

    public void record() {
        this.lastCallTimestamp.set(Instant.now());
    }

    static final class RntbdConnectionStateListenerMetricsJsonSerializer
    extends JsonSerializer<RntbdConnectionStateListenerMetrics> {
        public void serialize(RntbdConnectionStateListenerMetrics metrics, JsonGenerator writer, SerializerProvider serializers) throws IOException {
            writer.writeStartObject();
            if (metrics.lastCallTimestamp.get() != null) {
                writer.writeStringField("lastCallTimestamp", metrics.lastCallTimestamp.toString());
            }
            if (metrics.lastActionableContext.get() != null) {
                writer.writeStringField("lastActionableContext", ((Pair)metrics.lastActionableContext.get()).toString());
            }
            writer.writeEndObject();
        }
    }
}

