/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.directconnectivity;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosException;
import com.azure.cosmos.implementation.RequestTimeline;
import com.azure.cosmos.implementation.directconnectivity.StoreResponse;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdChannelAcquisitionTimeline;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdEndpointStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreResponseDiagnostics {
    static final Logger logger = LoggerFactory.getLogger(StoreResponseDiagnostics.class);
    private final String partitionKeyRangeId;
    private final String sessionTokenAsString;
    private final double requestCharge;
    private final String activityId;
    private final String correlatedActivityId;
    private final int statusCode;
    private final int subStatusCode;
    private final int pendingRequestQueueSize;
    private final int requestPayloadLength;
    private final int responsePayloadLength;
    private final RequestTimeline requestTimeline;
    private final RntbdChannelAcquisitionTimeline channelAcquisitionTimeline;
    private final int rntbdChannelTaskQueueSize;
    private final RntbdEndpointStatistics rntbdEndpointStatistics;
    private final int rntbdRequestLength;
    private final int rntbdResponseLength;
    private final String exceptionMessage;
    private final String exceptionResponseHeaders;

    public static StoreResponseDiagnostics createStoreResponseDiagnostics(StoreResponse storeResponse) {
        return new StoreResponseDiagnostics(storeResponse);
    }

    public static StoreResponseDiagnostics createStoreResponseDiagnostics(CosmosException cosmosException) {
        return new StoreResponseDiagnostics(cosmosException);
    }

    private StoreResponseDiagnostics(StoreResponse storeResponse) {
        this.partitionKeyRangeId = storeResponse.getPartitionKeyRangeId();
        this.activityId = storeResponse.getActivityId();
        this.correlatedActivityId = storeResponse.getCorrelatedActivityId();
        this.requestCharge = storeResponse.getRequestCharge();
        this.sessionTokenAsString = storeResponse.getSessionTokenString();
        this.statusCode = storeResponse.getStatus();
        this.subStatusCode = storeResponse.getSubStatusCode();
        this.pendingRequestQueueSize = storeResponse.getPendingRequestQueueSize();
        this.requestPayloadLength = storeResponse.getRequestPayloadLength();
        this.responsePayloadLength = storeResponse.getResponseBodyLength();
        this.requestTimeline = storeResponse.getRequestTimeline();
        this.channelAcquisitionTimeline = storeResponse.getChannelAcquisitionTimeline();
        this.rntbdChannelTaskQueueSize = storeResponse.getRntbdChannelTaskQueueSize();
        this.rntbdEndpointStatistics = storeResponse.getEndpointStatistics();
        this.rntbdRequestLength = storeResponse.getRntbdRequestLength();
        this.rntbdResponseLength = storeResponse.getRntbdResponseLength();
        this.exceptionMessage = null;
        this.exceptionResponseHeaders = null;
    }

    private StoreResponseDiagnostics(CosmosException e) {
        this.partitionKeyRangeId = BridgeInternal.getPartitionKeyRangeId(e);
        this.activityId = e.getActivityId();
        this.correlatedActivityId = e.getResponseHeaders().get("x-ms-cosmos-correlated-activityid");
        this.requestCharge = e.getRequestCharge();
        this.sessionTokenAsString = e.getResponseHeaders().get("x-ms-session-token");
        this.statusCode = e.getStatusCode();
        this.subStatusCode = e.getSubStatusCode();
        this.pendingRequestQueueSize = BridgeInternal.getRntbdPendingRequestQueueSize(e);
        this.requestPayloadLength = BridgeInternal.getRequestBodyLength(e);
        this.responsePayloadLength = BridgeInternal.getRntbdResponseLength(e);
        this.requestTimeline = BridgeInternal.getRequestTimeline(e);
        this.channelAcquisitionTimeline = BridgeInternal.getChannelAcqusitionTimeline(e);
        this.rntbdChannelTaskQueueSize = BridgeInternal.getChannelTaskQueueSize(e);
        this.rntbdEndpointStatistics = BridgeInternal.getServiceEndpointStatistics(e);
        this.rntbdRequestLength = BridgeInternal.getRntbdRequestLength(e);
        this.rntbdResponseLength = BridgeInternal.getRntbdResponseLength(e);
        this.exceptionMessage = BridgeInternal.getInnerErrorMessage(e);
        this.exceptionResponseHeaders = e.getResponseHeaders() != null ? e.getResponseHeaders().toString() : null;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public int getSubStatusCode() {
        return this.subStatusCode;
    }

    public int getPendingRequestQueueSize() {
        return this.pendingRequestQueueSize;
    }

    public int getRequestPayloadLength() {
        return this.requestPayloadLength;
    }

    public int getResponsePayloadLength() {
        return this.responsePayloadLength;
    }

    public RequestTimeline getRequestTimeline() {
        return this.requestTimeline;
    }

    public RntbdChannelAcquisitionTimeline getChannelAcquisitionTimeline() {
        return this.channelAcquisitionTimeline;
    }

    public int getRntbdChannelTaskQueueSize() {
        return this.rntbdChannelTaskQueueSize;
    }

    public RntbdEndpointStatistics getRntbdEndpointStatistics() {
        return this.rntbdEndpointStatistics;
    }

    public int getRntbdRequestLength() {
        return this.rntbdRequestLength;
    }

    public int getRntbdResponseLength() {
        return this.rntbdResponseLength;
    }

    public String getExceptionMessage() {
        return this.exceptionMessage;
    }

    public String getPartitionKeyRangeId() {
        return this.partitionKeyRangeId;
    }

    public String getSessionTokenAsString() {
        return this.sessionTokenAsString;
    }

    public double getRequestCharge() {
        return this.requestCharge;
    }

    public String getActivityId() {
        return this.activityId;
    }

    public String getCorrelatedActivityId() {
        return this.correlatedActivityId;
    }

    public String getExceptionResponseHeaders() {
        return this.exceptionResponseHeaders;
    }
}

